/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ClientUtilsTest {
    private static final Set<TopicPartition> PARTITIONS = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic", 1), new TopicPartition("topic", 2)});

    @Test
    public void fetchCommittedOffsetsShouldRethrowKafkaExceptionAsStreamsException() {
        Consumer consumer = (Consumer)EasyMock.createMock(Consumer.class);
        EasyMock.expect((Object)consumer.committed(PARTITIONS)).andThrow((Throwable)new KafkaException());
        EasyMock.replay((Object[])new Object[]{consumer});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchCommittedOffsets(PARTITIONS, (Consumer)consumer));
    }

    @Test
    public void fetchCommittedOffsetsShouldRethrowTimeoutException() {
        Consumer consumer = (Consumer)EasyMock.createMock(Consumer.class);
        EasyMock.expect((Object)consumer.committed(PARTITIONS)).andThrow((Throwable)new TimeoutException());
        EasyMock.replay((Object[])new Object[]{consumer});
        Assert.assertThrows(TimeoutException.class, () -> ClientUtils.fetchCommittedOffsets(PARTITIONS, (Consumer)consumer));
    }

    @Test
    public void fetchCommittedOffsetsShouldReturnEmptyMapIfPartitionsAreEmpty() {
        Consumer consumer = (Consumer)EasyMock.createMock(Consumer.class);
        Assert.assertTrue((boolean)ClientUtils.fetchCommittedOffsets(Collections.emptySet(), (Consumer)consumer).isEmpty());
    }

    @Test
    public void fetchEndOffsetsShouldReturnEmptyMapIfPartitionsAreEmpty() {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        Assert.assertTrue((boolean)ClientUtils.fetchEndOffsets(Collections.emptySet(), (Admin)adminClient).isEmpty());
    }

    @Test
    public void fetchEndOffsetsShouldRethrowRuntimeExceptionAsStreamsException() throws Exception {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        ListOffsetsResult result = (ListOffsetsResult)EasyMock.createNiceMock(ListOffsetsResult.class);
        KafkaFuture allFuture = (KafkaFuture)EasyMock.createMock(KafkaFuture.class);
        EasyMock.expect((Object)adminClient.listOffsets((Map)EasyMock.anyObject())).andStubReturn((Object)result);
        EasyMock.expect((Object)result.all()).andStubReturn((Object)allFuture);
        EasyMock.expect((Object)allFuture.get()).andThrow((Throwable)new RuntimeException());
        EasyMock.replay((Object[])new Object[]{adminClient, result, allFuture});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchEndOffsets(PARTITIONS, (Admin)adminClient));
        EasyMock.verify((Object[])new Object[]{adminClient});
    }

    @Test
    public void fetchEndOffsetsShouldRethrowInterruptedExceptionAsStreamsException() throws Exception {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        ListOffsetsResult result = (ListOffsetsResult)EasyMock.createNiceMock(ListOffsetsResult.class);
        KafkaFuture allFuture = (KafkaFuture)EasyMock.createMock(KafkaFuture.class);
        EasyMock.expect((Object)adminClient.listOffsets((Map)EasyMock.anyObject())).andStubReturn((Object)result);
        EasyMock.expect((Object)result.all()).andStubReturn((Object)allFuture);
        EasyMock.expect((Object)allFuture.get()).andThrow((Throwable)new InterruptedException());
        EasyMock.replay((Object[])new Object[]{adminClient, result, allFuture});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchEndOffsets(PARTITIONS, (Admin)adminClient));
        EasyMock.verify((Object[])new Object[]{adminClient});
    }

    @Test
    public void fetchEndOffsetsShouldRethrowExecutionExceptionAsStreamsException() throws Exception {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        ListOffsetsResult result = (ListOffsetsResult)EasyMock.createNiceMock(ListOffsetsResult.class);
        KafkaFuture allFuture = (KafkaFuture)EasyMock.createMock(KafkaFuture.class);
        EasyMock.expect((Object)adminClient.listOffsets((Map)EasyMock.anyObject())).andStubReturn((Object)result);
        EasyMock.expect((Object)result.all()).andStubReturn((Object)allFuture);
        EasyMock.expect((Object)allFuture.get()).andThrow((Throwable)new ExecutionException(new RuntimeException()));
        EasyMock.replay((Object[])new Object[]{adminClient, result, allFuture});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchEndOffsets(PARTITIONS, (Admin)adminClient));
        EasyMock.verify((Object[])new Object[]{adminClient});
    }
}

