/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapperSerde;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionWrapperSerdeTest {
    @Test
    public void shouldSerdeTest() {
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"originalKey");
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assert.assertEquals((Object)SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)deserialized.getInstruction());
        Assert.assertArrayEquals((long[])hashedValue, (long[])deserialized.getHash());
        Assert.assertEquals((Object)"originalKey", (Object)deserialized.getPrimaryKey());
    }

    @Test
    public void shouldSerdeNullHashTest() {
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = null;
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey");
        byte[] serialized = swSerde.serializer().serialize(null, (Object)wrapper);
        SubscriptionWrapper deserialized = (SubscriptionWrapper)swSerde.deserializer().deserialize(null, serialized);
        Assert.assertEquals((Object)SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)deserialized.getInstruction());
        Assert.assertArrayEquals(hashedValue, (long[])deserialized.getHash());
        Assert.assertEquals((Object)"originalKey", (Object)deserialized.getPrimaryKey());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowExceptionOnNullKeyTest() {
        Object originalKey = null;
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, originalKey);
        swSerde.serializer().serialize(null, (Object)wrapper);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowExceptionOnNullInstructionTest() {
        String originalKey = "originalKey";
        SubscriptionWrapperSerde swSerde = new SubscriptionWrapperSerde(() -> "pkTopic", Serdes.String());
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{-1, -86, 0, 25});
        SubscriptionWrapper wrapper = new SubscriptionWrapper(hashedValue, null, (Object)"originalKey");
        swSerde.serializer().serialize(null, (Object)wrapper);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowExceptionOnUnsupportedVersionTest() {
        String originalKey = "originalKey";
        long[] hashedValue = null;
        new SubscriptionWrapper(hashedValue, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"originalKey", -128);
    }
}

