/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KTableMapKeysTest {
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testMapKeysConvertingToStream() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic_map_keys";
        KTable table1 = builder.table("topic_map_keys", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(1, "ONE");
        keyMap.put(2, "TWO");
        keyMap.put(3, "THREE");
        KStream convertedStream = table1.toStream((key, value) -> (String)keyMap.get(key));
        KeyValueTimestamp[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<String, String>("ONE", "V_ONE", 5L), new KeyValueTimestamp<String, String>("TWO", "V_TWO", 10L), new KeyValueTimestamp<String, String>("THREE", "V_THREE", 15L)};
        int[] originalKeys = new int[]{1, 2, 3};
        String[] values = new String[]{"V_ONE", "V_TWO", "V_THREE"};
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        convertedStream.process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int i = 0; i < originalKeys.length; ++i) {
                TestInputTopic inputTopic = driver.createInputTopic("topic_map_keys", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
                inputTopic.pipeInput((Object)originalKeys[i], (Object)values[i], (long)(5 + i * 5));
            }
        }
        Assert.assertEquals((long)3L, (long)supplier.theCapturedProcessor().processed().size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], supplier.theCapturedProcessor().processed().get(i));
        }
    }
}

