/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KGroupedTableImplTest {
    private final StreamsBuilder builder = new StreamsBuilder();
    private static final String INVALID_STORE_NAME = "~foo bar~";
    private KGroupedTable<String, String> groupedTable;
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.Integer());
    private final String topic = "input";

    @Before
    public void before() {
        this.groupedTable = this.builder.table("blah", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper());
    }

    @Test(expected=TopologyException.class)
    public void shouldNotAllowInvalidStoreNameOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)INVALID_STORE_NAME));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInitializerOnAggregate() {
        this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullAdderOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSubtractorOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullAdderOnReduce() {
        this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSubtractorOnReduce() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, null, Materialized.as((String)"store"));
    }

    @Test(expected=TopologyException.class)
    public void shouldNotAllowInvalidStoreNameOnReduce() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, Materialized.as((String)INVALID_STORE_NAME));
    }

    private MockProcessorSupplier<String, Integer> getReducedResults(KTable<String, Integer> inputKTable) {
        MockProcessorSupplier<String, Integer> supplier = new MockProcessorSupplier<String, Integer>();
        inputKTable.toStream().process(supplier, new String[0]);
        return supplier;
    }

    private void assertReduced(Map<String, ValueAndTimestamp<Integer>> reducedResults, String topic, TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(topic, (Serializer)new StringSerializer(), (Serializer)new DoubleSerializer());
        inputTopic.pipeInput((Object)"A", (Object)1.1, 10L);
        inputTopic.pipeInput((Object)"B", (Object)2.2, 11L);
        Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)10L), reducedResults.get("A"));
        Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)11L), reducedResults.get("B"));
        inputTopic.pipeInput((Object)"A", (Object)2.6, 30L);
        inputTopic.pipeInput((Object)"B", (Object)1.3, 30L);
        inputTopic.pipeInput((Object)"A", (Object)5.7, 50L);
        inputTopic.pipeInput((Object)"B", (Object)6.2, 20L);
        Assert.assertEquals((Object)ValueAndTimestamp.make((Object)5, (long)50L), reducedResults.get("A"));
        Assert.assertEquals((Object)ValueAndTimestamp.make((Object)6, (long)30L), reducedResults.get("B"));
    }

    @Test
    public void shouldReduce() {
        KeyValueMapper intProjection = (key, value) -> KeyValue.pair((Object)key, (Object)value.intValue());
        KTable reduced = this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Double()), Materialized.as((String)"store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, Materialized.as((String)"reduced"));
        MockProcessorSupplier<String, Integer> supplier = this.getReducedResults((KTable<String, Integer>)reduced);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.assertReduced(supplier.theCapturedProcessor().lastValueAndTimestampPerKey(), "input", driver);
            Assert.assertEquals((Object)reduced.queryableStoreName(), (Object)"reduced");
        }
    }

    @Test
    public void shouldReduceWithInternalStoreName() {
        KeyValueMapper intProjection = (key, value) -> KeyValue.pair((Object)key, (Object)value.intValue());
        KTable reduced = this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Double()), Materialized.as((String)"store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR);
        MockProcessorSupplier<String, Integer> supplier = this.getReducedResults((KTable<String, Integer>)reduced);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.assertReduced(supplier.theCapturedProcessor().lastValueAndTimestampPerKey(), "input", driver);
            Assert.assertNull((Object)reduced.queryableStoreName());
        }
    }

    @Test
    public void shouldReduceAndMaterializeResults() {
        KeyValueMapper intProjection = (key, value) -> KeyValue.pair((Object)key, (Object)value.intValue());
        KTable reduced = this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, Materialized.as((String)"reduce").withKeySerde(Serdes.String()).withValueSerde(Serdes.Integer()));
        MockProcessorSupplier<String, Integer> supplier = this.getReducedResults((KTable<String, Integer>)reduced);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.assertReduced(supplier.theCapturedProcessor().lastValueAndTimestampPerKey(), "input", driver);
            KeyValueStore reduce = driver.getKeyValueStore("reduce");
            MatcherAssert.assertThat((Object)reduce.get((Object)"A"), (Matcher)CoreMatchers.equalTo((Object)5));
            MatcherAssert.assertThat((Object)reduce.get((Object)"B"), (Matcher)CoreMatchers.equalTo((Object)6));
            reduce = driver.getTimestampedKeyValueStore("reduce");
            MatcherAssert.assertThat((Object)reduce.get((Object)"A"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)5, (long)50L)));
            MatcherAssert.assertThat((Object)reduce.get((Object)"B"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)6, (long)30L)));
        }
    }

    @Test
    public void shouldCountAndMaterializeResults() {
        this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper(), Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).count(Materialized.as((String)"count").withKeySerde(Serdes.String()).withValueSerde(Serdes.Long()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData("input", driver);
            KeyValueStore counts = driver.getKeyValueStore("count");
            MatcherAssert.assertThat((Object)counts.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)3L));
            MatcherAssert.assertThat((Object)counts.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)2L));
            counts = driver.getTimestampedKeyValueStore("count");
            MatcherAssert.assertThat((Object)counts.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)3L, (long)50L)));
            MatcherAssert.assertThat((Object)counts.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)2L, (long)60L)));
        }
    }

    @Test
    public void shouldAggregateAndMaterializeResults() {
        this.builder.table("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper(), Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"aggregate").withValueSerde(Serdes.String()).withKeySerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData("input", driver);
            KeyValueStore aggregate = driver.getKeyValueStore("aggregate");
            MatcherAssert.assertThat((Object)aggregate.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)"0+1+1+1"));
            MatcherAssert.assertThat((Object)aggregate.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)"0+2+2"));
            aggregate = driver.getTimestampedKeyValueStore("aggregate");
            MatcherAssert.assertThat((Object)aggregate.get((Object)"1"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+1+1+1", (long)50L)));
            MatcherAssert.assertThat((Object)aggregate.get((Object)"2"), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+2+2", (long)60L)));
        }
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointOnCountWhenMaterializedIsNull() {
        this.groupedTable.count((Materialized)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceWhenMaterializedIsNull() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, (Materialized)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceWhenAdderIsNull() {
        this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceWhenSubtractorIsNull() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, null, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenInitializerIsNull() {
        this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenAdderIsNull() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenSubtractorIsNull() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as((String)"store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenMaterializedIsNull() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, (Materialized)null);
    }

    private void processData(String topic, TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(topic, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        inputTopic.pipeInput((Object)"A", (Object)"1", 10L);
        inputTopic.pipeInput((Object)"B", (Object)"1", 50L);
        inputTopic.pipeInput((Object)"C", (Object)"1", 30L);
        inputTopic.pipeInput((Object)"D", (Object)"2", 40L);
        inputTopic.pipeInput((Object)"E", (Object)"2", 60L);
    }
}

