/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.junit.Assert;
import org.junit.Test;

public class SlidingWindowsTest {
    private static final long ANY_SIZE = 123L;

    @Test
    public void shouldSetTimeDifference() {
        Assert.assertEquals((long)123L, (long)SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(123L), (Duration)Duration.ofMillis(3L)).timeDifferenceMs());
    }

    @Test
    public void timeDifferenceMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(-1L), (Duration)Duration.ofMillis(5L)));
    }

    @Test
    public void shouldSetGracePeriod() {
        Assert.assertEquals((long)123L, (long)SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(123L)).gracePeriodMs());
    }

    @Test
    public void gracePeriodMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        long grace = 1L + (long)(Math.random() * 19.0);
        long timeDifference = 1L + (long)(Math.random() * 19.0);
        EqualityCheck.verifyEquality(SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(timeDifference), (Duration)Duration.ofMillis(grace)), SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(timeDifference), (Duration)Duration.ofMillis(grace)));
    }

    @Test
    public void equalsAndHashcodeShouldNotBeEqualForDifferentTimeDifference() {
        long grace = 1L + (long)(Math.random() * 9.0);
        long timeDifferenceOne = 1L + (long)(Math.random() * 9.0);
        long timeDifferenceTwo = 21L + (long)(Math.random() * 20.0);
        EqualityCheck.verifyInEquality(SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(timeDifferenceOne), (Duration)Duration.ofMillis(grace)), SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(timeDifferenceTwo), (Duration)Duration.ofMillis(grace)));
    }

    @Test
    public void equalsAndHashcodeShouldNotBeEqualForDifferentGracePeriod() {
        long timeDifference = 1L + (long)(Math.random() * 9.0);
        long graceOne = 1L + (long)(Math.random() * 9.0);
        long graceTwo = 21L + (long)(Math.random() * 20.0);
        EqualityCheck.verifyInEquality(SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(timeDifference), (Duration)Duration.ofMillis(graceOne)), SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(timeDifference), (Duration)Duration.ofMillis(graceTwo)));
    }
}

