/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class KeyValueSegmentTest {
    @Test
    public void shouldDeleteStateDirectoryOnDestroy() throws Exception {
        KeyValueSegment segment = new KeyValueSegment("segment", "window", 0L);
        String directoryPath = TestUtils.tempDirectory().getAbsolutePath();
        File directory = new File(directoryPath);
        ProcessorContext mockContext = (ProcessorContext)EasyMock.mock(ProcessorContext.class);
        EasyMock.expect((Object)mockContext.appConfigs()).andReturn(Collections.emptyMap());
        EasyMock.expect((Object)mockContext.stateDir()).andReturn((Object)directory);
        EasyMock.replay((Object[])new Object[]{mockContext});
        segment.openDB(mockContext);
        Assert.assertTrue((boolean)new File(directoryPath, "window").exists());
        Assert.assertTrue((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assert.assertTrue((new File(directoryPath + File.separator + "window", "segment").list().length > 0 ? 1 : 0) != 0);
        segment.destroy();
        Assert.assertFalse((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assert.assertTrue((boolean)new File(directoryPath, "window").exists());
    }

    @Test
    public void shouldBeEqualIfIdIsEqual() {
        KeyValueSegment segment = new KeyValueSegment("anyName", "anyName", 0L);
        KeyValueSegment segmentSameId = new KeyValueSegment("someOtherName", "someOtherName", 0L);
        KeyValueSegment segmentDifferentId = new KeyValueSegment("anyName", "anyName", 1L);
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segment));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segmentSameId));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)segmentDifferentId)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"anyName")));
    }

    @Test
    public void shouldHashOnSegmentIdOnly() {
        KeyValueSegment segment = new KeyValueSegment("anyName", "anyName", 0L);
        KeyValueSegment segmentSameId = new KeyValueSegment("someOtherName", "someOtherName", 0L);
        KeyValueSegment segmentDifferentId = new KeyValueSegment("anyName", "anyName", 1L);
        HashSet<KeyValueSegment> set = new HashSet<KeyValueSegment>();
        Assert.assertTrue((boolean)set.add(segment));
        Assert.assertFalse((boolean)set.add(segmentSameId));
        Assert.assertTrue((boolean)set.add(segmentDifferentId));
    }

    @Test
    public void shouldCompareSegmentIdOnly() {
        KeyValueSegment segment1 = new KeyValueSegment("a", "C", 50L);
        KeyValueSegment segment2 = new KeyValueSegment("b", "B", 100L);
        KeyValueSegment segment3 = new KeyValueSegment("c", "A", 0L);
        MatcherAssert.assertThat((Object)segment1.compareTo(segment1), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment1), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment1), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
    }
}

