/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionInfoTest {
    private final UUID processId = UUID.randomUUID();
    private final Set<TaskId> activeTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0)));
    private final Set<TaskId> standbyTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(1, 1), new TaskId(2, 0)));
    private static final String IGNORED_USER_ENDPOINT = "ignoredUserEndpoint:80";

    @Test
    public void shouldUseLatestSupportedVersionByDefault() {
        SubscriptionInfo info = new SubscriptionInfo(this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((long)4L, (long)info.version());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownVersion1() {
        new SubscriptionInfo(0, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownVersion2() {
        new SubscriptionInfo(5, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
    }

    @Test
    public void shouldEncodeAndDecodeVersion1() {
        SubscriptionInfo info = new SubscriptionInfo(1, this.processId, this.activeTasks, this.standbyTasks, IGNORED_USER_ENDPOINT);
        SubscriptionInfo expectedInfo = new SubscriptionInfo(1, -1, this.processId, this.activeTasks, this.standbyTasks, null);
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion2() {
        SubscriptionInfo info = new SubscriptionInfo(2, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        SubscriptionInfo expectedInfo = new SubscriptionInfo(2, -1, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion3() {
        SubscriptionInfo info = new SubscriptionInfo(3, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        SubscriptionInfo expectedInfo = new SubscriptionInfo(3, 4, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion4() {
        SubscriptionInfo info = new SubscriptionInfo(4, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        SubscriptionInfo expectedInfo = new SubscriptionInfo(4, 4, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldAllowToDecodeFutureSupportedVersion() {
        SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)this.encodeFutureVersion());
        Assert.assertEquals((long)5L, (long)info.version());
        Assert.assertEquals((long)5L, (long)info.latestSupportedVersion());
    }

    @Test
    public void shouldEncodeAndDecodeSmallerLatestSupportedVersion() {
        int usedVersion = 3;
        int latestSupportedVersion = 3;
        SubscriptionInfo info = new SubscriptionInfo(3, 3, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        SubscriptionInfo expectedInfo = new SubscriptionInfo(3, 3, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    private ByteBuffer encodeFutureVersion() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(5);
        buf.putInt(5);
        return buf;
    }
}

