/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.BatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.internals.RecordBatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.internals.StateRestoreCallbackAdapter;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class StateRestoreCallbackAdapterTest {
    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnRestoreAll() {
        StateRestoreCallbackAdapter.adapt((StateRestoreCallback)((StateRestoreCallback)EasyMock.mock(StateRestoreCallback.class))).restoreAll(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnRestore() {
        StateRestoreCallbackAdapter.adapt((StateRestoreCallback)((StateRestoreCallback)EasyMock.mock(StateRestoreCallback.class))).restore(null, null);
    }

    @Test
    public void shouldPassRecordsThrough() {
        ArrayList<ConsumerRecord<byte[], byte[]>> actual = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordBatchingStateRestoreCallback callback = actual::addAll;
        RecordBatchingStateRestoreCallback adapted = StateRestoreCallbackAdapter.adapt((StateRestoreCallback)callback);
        byte[] key1 = new byte[]{1};
        byte[] value1 = new byte[]{2};
        byte[] key2 = new byte[]{3};
        byte[] value2 = new byte[]{4};
        List<ConsumerRecord<byte[], byte[]>> recordList = Arrays.asList(new ConsumerRecord("topic1", 0, 0L, (Object)key1, (Object)value1), new ConsumerRecord("topic2", 1, 1L, (Object)key2, (Object)value2));
        adapted.restoreBatch(recordList);
        this.validate(actual, recordList);
    }

    @Test
    public void shouldConvertToKeyValueBatches() {
        final ArrayList actual = new ArrayList();
        BatchingStateRestoreCallback callback = new BatchingStateRestoreCallback(){

            public void restoreAll(Collection<KeyValue<byte[], byte[]>> records) {
                actual.addAll(records);
            }

            public void restore(byte[] key, byte[] value) {
            }
        };
        RecordBatchingStateRestoreCallback adapted = StateRestoreCallbackAdapter.adapt((StateRestoreCallback)callback);
        byte[] key1 = new byte[]{1};
        byte[] value1 = new byte[]{2};
        byte[] key2 = new byte[]{3};
        byte[] value2 = new byte[]{4};
        adapted.restoreBatch(Arrays.asList(new ConsumerRecord("topic1", 0, 0L, (Object)key1, (Object)value1), new ConsumerRecord("topic2", 1, 1L, (Object)key2, (Object)value2)));
        MatcherAssert.assertThat(actual, (Matcher)Is.is(Arrays.asList(new KeyValue((Object)key1, (Object)value1), new KeyValue((Object)key2, (Object)value2))));
    }

    @Test
    public void shouldConvertToKeyValue() {
        ArrayList actual = new ArrayList();
        StateRestoreCallback callback = (key, value) -> actual.add(new KeyValue((Object)key, (Object)value));
        RecordBatchingStateRestoreCallback adapted = StateRestoreCallbackAdapter.adapt((StateRestoreCallback)callback);
        byte[] key1 = new byte[]{1};
        byte[] value1 = new byte[]{2};
        byte[] key2 = new byte[]{3};
        byte[] value2 = new byte[]{4};
        adapted.restoreBatch(Arrays.asList(new ConsumerRecord("topic1", 0, 0L, (Object)key1, (Object)value1), new ConsumerRecord("topic2", 1, 1L, (Object)key2, (Object)value2)));
        MatcherAssert.assertThat(actual, (Matcher)Is.is(Arrays.asList(new KeyValue((Object)key1, (Object)value1), new KeyValue((Object)key2, (Object)value2))));
    }

    private void validate(List<ConsumerRecord<byte[], byte[]>> actual, List<ConsumerRecord<byte[], byte[]>> expected) {
        MatcherAssert.assertThat((Object)actual.size(), (Matcher)Is.is((Object)expected.size()));
        for (int i = 0; i < actual.size(); ++i) {
            ConsumerRecord<byte[], byte[]> actual1 = actual.get(i);
            ConsumerRecord<byte[], byte[]> expected1 = expected.get(i);
            MatcherAssert.assertThat((Object)actual1.topic(), (Matcher)Is.is((Object)expected1.topic()));
            MatcherAssert.assertThat((Object)actual1.partition(), (Matcher)Is.is((Object)expected1.partition()));
            MatcherAssert.assertThat((Object)actual1.offset(), (Matcher)Is.is((Object)expected1.offset()));
            MatcherAssert.assertThat((Object)actual1.key(), (Matcher)Is.is((Object)expected1.key()));
            MatcherAssert.assertThat((Object)actual1.value(), (Matcher)Is.is((Object)expected1.value()));
            MatcherAssert.assertThat((Object)actual1.timestamp(), (Matcher)Is.is((Object)expected1.timestamp()));
            MatcherAssert.assertThat((Object)actual1.headers(), (Matcher)Is.is((Object)expected1.headers()));
        }
    }
}

