/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.test.KeyValueIteratorStub;

public class ReadOnlySessionStoreStub<K, V>
implements ReadOnlySessionStore<K, V>,
StateStore {
    private NavigableMap<K, List<KeyValue<Windowed<K>, V>>> sessions = new TreeMap<K, List<KeyValue<Windowed<K>, V>>>();
    private boolean open = true;

    public void put(Windowed<K> sessionKey, V value) {
        if (!this.sessions.containsKey(sessionKey.key())) {
            this.sessions.put(sessionKey.key(), new ArrayList());
        }
        ((List)this.sessions.get(sessionKey.key())).add(KeyValue.pair(sessionKey, value));
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K key) {
        if (!this.open) {
            throw new InvalidStateStoreException("not open");
        }
        if (!this.sessions.containsKey(key)) {
            return new KeyValueIteratorStub(Collections.emptyIterator());
        }
        return new KeyValueIteratorStub(((List)this.sessions.get(key)).iterator());
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to) {
        if (!this.open) {
            throw new InvalidStateStoreException("not open");
        }
        if (this.sessions.subMap(from, true, to, true).isEmpty()) {
            return new KeyValueIteratorStub(Collections.emptyIterator());
        }
        final Iterator keysIterator = this.sessions.subMap(from, true, to, true).values().iterator();
        return new KeyValueIteratorStub(new Iterator<KeyValue<Windowed<K>, V>>(){
            Iterator<KeyValue<Windowed<K>, V>> it;

            @Override
            public boolean hasNext() {
                while (this.it == null || !this.it.hasNext()) {
                    if (!keysIterator.hasNext()) {
                        return false;
                    }
                    this.it = ((List)keysIterator.next()).iterator();
                }
                return true;
            }

            @Override
            public KeyValue<Windowed<K>, V> next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public String name() {
        return "";
    }

    public void init(ProcessorContext context, StateStore root) {
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }
}

