/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.streams.state.internals.RecordConverter;
import org.apache.kafka.streams.state.internals.RecordConverters;
import org.junit.Assert;
import org.junit.Test;

public class RecordConvertersTest {
    private final RecordConverter timestampedValueConverter = RecordConverters.rawValueToTimestampedValue();

    @Test
    public void shouldPreserveNullValueOnConversion() {
        ConsumerRecord nullValueRecord = new ConsumerRecord("", 0, 0L, (Object)new byte[0], null);
        Assert.assertNull((Object)this.timestampedValueConverter.convert(nullValueRecord).value());
    }

    @Test
    public void shouldAddTimestampToValueOnConversionWhenValueIsNotNull() {
        long timestamp = 10L;
        byte[] value = new byte[1];
        ConsumerRecord inputRecord = new ConsumerRecord("topic", 1, 0L, 10L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)new byte[0], (Object)value);
        byte[] expectedValue = ByteBuffer.allocate(9).putLong(10L).put(value).array();
        byte[] actualValue = (byte[])this.timestampedValueConverter.convert(inputRecord).value();
        Assert.assertArrayEquals((byte[])expectedValue, (byte[])actualValue);
    }
}

