/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyValueSegmentsTest {
    private static final int NUM_SEGMENTS = 5;
    private static final long SEGMENT_INTERVAL = 100L;
    private static final long RETENTION_PERIOD = 400L;
    private InternalMockProcessorContext context;
    private KeyValueSegments segments;
    private File stateDirectory;
    private final String storeName = "test";

    @Before
    public void createContext() {
        this.stateDirectory = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.stateDirectory, Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.segments = new KeyValueSegments("test", 400L, 100L);
    }

    @After
    public void close() {
        this.segments.close();
    }

    @Test
    public void shouldGetSegmentIdsFromTimestamp() {
        Assert.assertEquals((long)0L, (long)this.segments.segmentId(0L));
        Assert.assertEquals((long)1L, (long)this.segments.segmentId(100L));
        Assert.assertEquals((long)2L, (long)this.segments.segmentId(200L));
        Assert.assertEquals((long)3L, (long)this.segments.segmentId(300L));
    }

    @Test
    public void shouldBaseSegmentIntervalOnRetentionAndNumSegments() {
        KeyValueSegments segments = new KeyValueSegments("test", 800L, 200L);
        Assert.assertEquals((long)0L, (long)segments.segmentId(0L));
        Assert.assertEquals((long)0L, (long)segments.segmentId(100L));
        Assert.assertEquals((long)1L, (long)segments.segmentId(200L));
    }

    @Test
    public void shouldGetSegmentNameFromId() {
        Assert.assertEquals((Object)"test.0", (Object)this.segments.segmentName(0L));
        Assert.assertEquals((Object)"test.100", (Object)this.segments.segmentName(1L));
        Assert.assertEquals((Object)"test.200", (Object)this.segments.segmentName(2L));
    }

    @Test
    public void shouldCreateSegments() {
        KeyValueSegment segment1 = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        KeyValueSegment segment2 = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(1L, (InternalProcessorContext)this.context, -1L);
        KeyValueSegment segment3 = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(2L, (InternalProcessorContext)this.context, -1L);
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test.0").isDirectory());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test.100").isDirectory());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test.200").isDirectory());
        Assert.assertTrue((boolean)segment1.isOpen());
        Assert.assertTrue((boolean)segment2.isOpen());
        Assert.assertTrue((boolean)segment3.isOpen());
    }

    @Test
    public void shouldNotCreateSegmentThatIsAlreadyExpired() {
        long streamTime = this.updateStreamTimeAndCreateSegment(7);
        Assert.assertNull((Object)this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, streamTime));
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test.0").exists());
    }

    @Test
    public void shouldCleanupSegmentsThatHaveExpired() {
        KeyValueSegment segment1 = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        KeyValueSegment segment2 = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(1L, (InternalProcessorContext)this.context, -1L);
        KeyValueSegment segment3 = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(7L, (InternalProcessorContext)this.context, 700L);
        Assert.assertFalse((boolean)segment1.isOpen());
        Assert.assertFalse((boolean)segment2.isOpen());
        Assert.assertTrue((boolean)segment3.isOpen());
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test.0").exists());
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test.100").exists());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test.700").exists());
    }

    @Test
    public void shouldGetSegmentForTimestamp() {
        KeyValueSegment segment = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(1L, (InternalProcessorContext)this.context, -1L);
        Assert.assertEquals((Object)segment, (Object)this.segments.getSegmentForTimestamp(0L));
    }

    @Test
    public void shouldGetCorrectSegmentString() {
        KeyValueSegment segment = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        Assert.assertEquals((Object)"KeyValueSegment(id=0, name=test.0)", (Object)segment.toString());
    }

    @Test
    public void shouldCloseAllOpenSegments() {
        KeyValueSegment first = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        KeyValueSegment second = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(1L, (InternalProcessorContext)this.context, -1L);
        KeyValueSegment third = (KeyValueSegment)this.segments.getOrCreateSegmentIfLive(2L, (InternalProcessorContext)this.context, -1L);
        this.segments.close();
        Assert.assertFalse((boolean)first.isOpen());
        Assert.assertFalse((boolean)second.isOpen());
        Assert.assertFalse((boolean)third.isOpen());
    }

    @Test
    public void shouldOpenExistingSegments() {
        this.segments = new KeyValueSegments("test", 4L, 1L);
        this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(1L, (InternalProcessorContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(2L, (InternalProcessorContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(3L, (InternalProcessorContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(4L, (InternalProcessorContext)this.context, -1L);
        this.segments.close();
        this.segments = new KeyValueSegments("test", 4L, 1L);
        this.segments.openExisting((InternalProcessorContext)this.context, -1L);
        Assert.assertTrue((boolean)((KeyValueSegment)this.segments.getSegmentForTimestamp(0L)).isOpen());
        Assert.assertTrue((boolean)((KeyValueSegment)this.segments.getSegmentForTimestamp(1L)).isOpen());
        Assert.assertTrue((boolean)((KeyValueSegment)this.segments.getSegmentForTimestamp(2L)).isOpen());
        Assert.assertTrue((boolean)((KeyValueSegment)this.segments.getSegmentForTimestamp(3L)).isOpen());
        Assert.assertTrue((boolean)((KeyValueSegment)this.segments.getSegmentForTimestamp(4L)).isOpen());
    }

    @Test
    public void shouldGetSegmentsWithinTimeRange() {
        this.updateStreamTimeAndCreateSegment(0);
        this.updateStreamTimeAndCreateSegment(1);
        this.updateStreamTimeAndCreateSegment(2);
        this.updateStreamTimeAndCreateSegment(3);
        long streamTime = this.updateStreamTimeAndCreateSegment(4);
        this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(1L, (InternalProcessorContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(2L, (InternalProcessorContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(3L, (InternalProcessorContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(4L, (InternalProcessorContext)this.context, streamTime);
        List segments = this.segments.segments(0L, 200L);
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((long)0L, (long)((KeyValueSegment)segments.get((int)0)).id);
        Assert.assertEquals((long)1L, (long)((KeyValueSegment)segments.get((int)1)).id);
        Assert.assertEquals((long)2L, (long)((KeyValueSegment)segments.get((int)2)).id);
    }

    @Test
    public void shouldGetSegmentsWithinTimeRangeOutOfOrder() {
        this.updateStreamTimeAndCreateSegment(4);
        this.updateStreamTimeAndCreateSegment(2);
        this.updateStreamTimeAndCreateSegment(0);
        this.updateStreamTimeAndCreateSegment(1);
        this.updateStreamTimeAndCreateSegment(3);
        List segments = this.segments.segments(0L, 200L);
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((long)0L, (long)((KeyValueSegment)segments.get((int)0)).id);
        Assert.assertEquals((long)1L, (long)((KeyValueSegment)segments.get((int)1)).id);
        Assert.assertEquals((long)2L, (long)((KeyValueSegment)segments.get((int)2)).id);
    }

    @Test
    public void shouldRollSegments() {
        this.updateStreamTimeAndCreateSegment(0);
        this.verifyCorrectSegments(0L, 1);
        this.updateStreamTimeAndCreateSegment(1);
        this.verifyCorrectSegments(0L, 2);
        this.updateStreamTimeAndCreateSegment(2);
        this.verifyCorrectSegments(0L, 3);
        this.updateStreamTimeAndCreateSegment(3);
        this.verifyCorrectSegments(0L, 4);
        this.updateStreamTimeAndCreateSegment(4);
        this.verifyCorrectSegments(0L, 5);
        this.updateStreamTimeAndCreateSegment(5);
        this.verifyCorrectSegments(1L, 5);
        this.updateStreamTimeAndCreateSegment(6);
        this.verifyCorrectSegments(2L, 5);
    }

    @Test
    public void futureEventsShouldNotCauseSegmentRoll() {
        this.updateStreamTimeAndCreateSegment(0);
        this.verifyCorrectSegments(0L, 1);
        this.updateStreamTimeAndCreateSegment(1);
        this.verifyCorrectSegments(0L, 2);
        this.updateStreamTimeAndCreateSegment(2);
        this.verifyCorrectSegments(0L, 3);
        this.updateStreamTimeAndCreateSegment(3);
        this.verifyCorrectSegments(0L, 4);
        long streamTime = this.updateStreamTimeAndCreateSegment(4);
        this.verifyCorrectSegments(0L, 5);
        this.segments.getOrCreateSegmentIfLive(5L, (InternalProcessorContext)this.context, streamTime);
        this.verifyCorrectSegments(0L, 6);
        this.segments.getOrCreateSegmentIfLive(6L, (InternalProcessorContext)this.context, streamTime);
        this.verifyCorrectSegments(0L, 7);
    }

    private long updateStreamTimeAndCreateSegment(int segment) {
        long streamTime = 100L * (long)segment;
        this.segments.getOrCreateSegmentIfLive((long)segment, (InternalProcessorContext)this.context, streamTime);
        return streamTime;
    }

    @Test
    public void shouldUpdateSegmentFileNameFromOldDateFormatToNewFormat() throws Exception {
        int segmentId;
        long segmentInterval = 60000L;
        this.segments = new KeyValueSegments("test", 300000L, 60000L);
        String storeDirectoryPath = this.stateDirectory.getAbsolutePath() + File.separator + "test";
        File storeDirectory = new File(storeDirectoryPath);
        storeDirectory.mkdirs();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File oldSegment = new File(storeDirectoryPath + File.separator + "test" + "-" + formatter.format(new Date((long)segmentId * 60000L)));
            oldSegment.createNewFile();
        }
        this.segments.openExisting((InternalProcessorContext)this.context, -1L);
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            String segmentName = "test." + (long)segmentId * 60000L;
            File newSegment = new File(storeDirectoryPath + File.separator + segmentName);
            Assert.assertTrue((boolean)newSegment.exists());
        }
    }

    @Test
    public void shouldUpdateSegmentFileNameFromOldColonFormatToNewFormat() throws Exception {
        int segmentId;
        String storeDirectoryPath = this.stateDirectory.getAbsolutePath() + File.separator + "test";
        File storeDirectory = new File(storeDirectoryPath);
        storeDirectory.mkdirs();
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File oldSegment = new File(storeDirectoryPath + File.separator + "test" + ":" + (long)segmentId * 100L);
            oldSegment.createNewFile();
        }
        this.segments.openExisting((InternalProcessorContext)this.context, -1L);
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File newSegment = new File(storeDirectoryPath + File.separator + "test" + "." + (long)segmentId * 100L);
            Assert.assertTrue((boolean)newSegment.exists());
        }
    }

    @Test
    public void shouldClearSegmentsOnClose() {
        this.segments.getOrCreateSegmentIfLive(0L, (InternalProcessorContext)this.context, -1L);
        this.segments.close();
        MatcherAssert.assertThat((Object)this.segments.getSegmentForTimestamp(0L), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void verifyCorrectSegments(long first, int numSegments) {
        List result = this.segments.segments(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)numSegments, (long)result.size());
        for (int i = 0; i < numSegments; ++i) {
            Assert.assertEquals((long)((long)i + first), (long)((KeyValueSegment)result.get((int)i)).id);
        }
    }
}

