/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordBatchingStateRestoreCallback;
import org.apache.kafka.streams.state.internals.ContextualRecord;
import org.apache.kafka.streams.state.internals.InMemoryTimeOrderedKeyValueBuffer;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeOrderedKeyValueBufferTest<B extends TimeOrderedKeyValueBuffer<String, String>> {
    private static final RecordHeaders V_1_CHANGELOG_HEADERS = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{1})});
    private static final String APP_ID = "test-app";
    private final Function<String, B> bufferSupplier;
    private final String testName;

    @Parameterized.Parameters(name="{index}: test={0}")
    public static Collection<Object[]> parameters() {
        return Collections.singletonList(new Object[]{"in-memory buffer", name -> new InMemoryTimeOrderedKeyValueBuffer.Builder(name, Serdes.String(), Serdes.String()).build()});
    }

    public TimeOrderedKeyValueBufferTest(String testName, Function<String, B> bufferSupplier) {
        this.testName = testName + "_" + new Random().nextInt(Integer.MAX_VALUE);
        this.bufferSupplier = bufferSupplier;
    }

    private static MockInternalProcessorContext makeContext() {
        Properties properties = new Properties();
        properties.setProperty("application.id", APP_ID);
        properties.setProperty("bootstrap.servers", "");
        TaskId taskId = new TaskId(0, 0);
        MockInternalProcessorContext context = new MockInternalProcessorContext(properties, taskId, TestUtils.tempDirectory());
        context.setRecordCollector(new MockInternalProcessorContext.MockRecordCollector());
        return context;
    }

    private static void cleanup(MockInternalProcessorContext context, TimeOrderedKeyValueBuffer<String, String> buffer) {
        try {
            buffer.close();
            Utils.delete((File)context.stateDir());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void shouldInit() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldAcceptData() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "asdf", "2p93nf");
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldRejectNullValues() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        try {
            buffer.put(0L, (Object)"asdf", null, TimeOrderedKeyValueBufferTest.getContext(0L));
            Assert.fail((String)"expected an exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldRemoveData() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "asdf", "qwer");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        buffer.evictWhile(() -> true, kv -> {});
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)0));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldRespectEvictionPredicate() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "asdf", "eyt");
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 1L, 0L, "zxcv", "rtg");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> buffer.numRecords() > 1, evicted::add);
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Collections.singletonList(new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)"eyt", TimeOrderedKeyValueBufferTest.getContext(0L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldTrackCount() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "asdf", "oin");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 1L, 0L, "asdf", "wekjn");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "zxcv", "24inf");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldTrackSize() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "asdf", "23roni");
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)43L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 1L, 0L, "asdf", "3l");
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)39L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "zxcv", "qfowin");
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)82L));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldTrackMinTimestamp() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 1L, 0L, "asdf", "2093j");
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "zxcv", "3gon4i");
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldEvictOldestAndUpdateSizeAndCountAndMinTimestamp() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 1L, 0L, "zxcv", "o23i4");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)42L));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 0L, "asdf", "3ng");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)82L));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        AtomicInteger callbackCount = new AtomicInteger(0);
        buffer.evictWhile(() -> true, kv -> {
            switch (callbackCount.incrementAndGet()) {
                case 1: {
                    MatcherAssert.assertThat((Object)kv.key(), (Matcher)Matchers.is((Object)"asdf"));
                    MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
                    MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)82L));
                    MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
                    break;
                }
                case 2: {
                    MatcherAssert.assertThat((Object)kv.key(), (Matcher)Matchers.is((Object)"zxcv"));
                    MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
                    MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)42L));
                    MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
                    break;
                }
                default: {
                    Assert.fail((String)"too many invocations");
                }
            }
        });
        MatcherAssert.assertThat((Object)callbackCount.get(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)Long.MAX_VALUE));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldFlush() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 2L, 0L, "asdf", "2093j");
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 1L, 1L, "zxcv", "3gon4i");
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String>)buffer, context, 0L, 2L, "deleteme", "deadbeef");
        buffer.evictWhile(() -> buffer.minTimestamp() < 1L, kv -> {});
        buffer.flush();
        List collected = ((MockInternalProcessorContext.MockRecordCollector)context.recordCollector()).collected().stream().map(pr -> {
            KeyValue niceValue;
            if (pr.value() == null) {
                niceValue = null;
            } else {
                byte[] timestampAndValue = (byte[])pr.value();
                ByteBuffer wrap = ByteBuffer.wrap(timestampAndValue);
                long timestamp = wrap.getLong();
                ContextualRecord contextualRecord = ContextualRecord.deserialize((ByteBuffer)wrap);
                niceValue = new KeyValue((Object)timestamp, (Object)contextualRecord);
            }
            return new ProducerRecord(pr.topic(), pr.partition(), pr.timestamp(), (Object)new String((byte[])pr.key(), StandardCharsets.UTF_8), (Object)niceValue, (Iterable)pr.headers());
        }).collect(Collectors.toList());
        MatcherAssert.assertThat(collected, (Matcher)Matchers.is(Arrays.asList(new ProducerRecord("test-app-" + this.testName + "-changelog", Integer.valueOf(0), null, (Object)"deleteme", null, (Iterable)new RecordHeaders()), new ProducerRecord("test-app-" + this.testName + "-changelog", Integer.valueOf(0), null, (Object)"zxcv", (Object)new KeyValue((Object)1L, (Object)TimeOrderedKeyValueBufferTest.getRecord("3gon4i", 1L)), (Iterable)V_1_CHANGELOG_HEADERS), new ProducerRecord("test-app-" + this.testName + "-changelog", Integer.valueOf(0), null, (Object)"asdf", (Object)new KeyValue((Object)2L, (Object)TimeOrderedKeyValueBufferTest.getRecord("2093j", 0L)), (Iterable)V_1_CHANGELOG_HEADERS))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldRestoreOldFormat() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(this.testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", null));
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 0L, TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(14).putLong(0L).put("doomed".getBytes(StandardCharsets.UTF_8)).array()), new ConsumerRecord("changelog-topic", 0, 1L, 1L, TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(12).putLong(2L).put("qwer".getBytes(StandardCharsets.UTF_8)).array()), new ConsumerRecord("changelog-topic", 0, 2L, 2L, TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(13).putLong(1L).put("3o4im".getBytes(StandardCharsets.UTF_8)).array())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)160L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null)));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)103L));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)"3o4im", new ProcessorRecordContext(2L, 2L, 0, "changelog-topic", (Headers)new RecordHeaders())), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)"qwer", new ProcessorRecordContext(1L, 1L, 0, "changelog-topic", (Headers)new RecordHeaders())))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    @Test
    public void shouldRestoreNewFormat() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(this.testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", null));
        RecordHeaders v1FlagHeaders = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{1})});
        byte[] todeleteValue = TimeOrderedKeyValueBufferTest.getRecord("doomed", 0L).serialize();
        byte[] asdfValue = TimeOrderedKeyValueBufferTest.getRecord("qwer", 1L).serialize();
        byte[] zxcvValue = TimeOrderedKeyValueBufferTest.getRecord("3o4im", 2L).serialize();
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, Long.valueOf(-1L), -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(8 + todeleteValue.length).putLong(0L).put(todeleteValue).array(), (Headers)v1FlagHeaders), new ConsumerRecord("changelog-topic", 0, 1L, 9999L, TimestampType.CREATE_TIME, Long.valueOf(-1L), -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(8 + asdfValue.length).putLong(2L).put(asdfValue).array(), (Headers)v1FlagHeaders), new ConsumerRecord("changelog-topic", 0, 2L, 99L, TimestampType.CREATE_TIME, Long.valueOf(-1L), -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(8 + zxcvValue.length).putLong(1L).put(zxcvValue).array(), (Headers)v1FlagHeaders)));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)130L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1L, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null)));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)83L));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)"3o4im", TimeOrderedKeyValueBufferTest.getContext(2L)), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)"qwer", TimeOrderedKeyValueBufferTest.getContext(1L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotRestoreUnrecognizedVersionRecord() {
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)this.bufferSupplier.apply(this.testName);
        MockInternalProcessorContext context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init((ProcessorContext)context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(this.testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", null));
        RecordHeaders unknownFlagHeaders = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{-1})});
        byte[] todeleteValue = TimeOrderedKeyValueBufferTest.getRecord("doomed", 0L).serialize();
        try {
            stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, Long.valueOf(-1L), -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(8 + todeleteValue.length).putLong(0L).put(todeleteValue).array(), (Headers)unknownFlagHeaders)));
            Assert.fail((String)"expected an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String>)buffer);
        }
    }

    private static void putRecord(TimeOrderedKeyValueBuffer<String, String> buffer, MockInternalProcessorContext context, long streamTime, long recordTimestamp, String key, String value) {
        ProcessorRecordContext recordContext = TimeOrderedKeyValueBufferTest.getContext(recordTimestamp);
        context.setRecordContext(recordContext);
        buffer.put(streamTime, (Object)key, (Object)value, recordContext);
    }

    private static ContextualRecord getRecord(String value, long timestamp) {
        return new ContextualRecord(value.getBytes(StandardCharsets.UTF_8), TimeOrderedKeyValueBufferTest.getContext(timestamp));
    }

    private static ProcessorRecordContext getContext(long recordTimestamp) {
        return new ProcessorRecordContext(recordTimestamp, 0L, 0, "topic", null);
    }
}

