/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFilterTest {
    private final String topicName = "topic";
    private final ConsumerRecordFactory<Integer, String> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());
    private final Predicate<Integer, String> isMultipleOfThree = new Predicate<Integer, String>(){

        public boolean test(Integer key, String value) {
            return key % 3 == 0;
        }
    };

    @Test
    public void testFilter() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6, 7};
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.filter(this.isMultipleOfThree).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create("topic", (Object)expectedKey, (Object)("V" + expectedKey)));
            }
        }
        Assert.assertEquals((long)2L, (long)supplier.theCapturedProcessor().processed.size());
    }

    @Test
    public void testFilterNot() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6, 7};
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.filterNot(this.isMultipleOfThree).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create("topic", (Object)expectedKey, (Object)("V" + expectedKey)));
            }
        }
        Assert.assertEquals((long)5L, (long)supplier.theCapturedProcessor().processed.size());
    }

    @Test
    public void testTypeVariance() {
        Predicate<Number, Object> numberKeyPredicate = new Predicate<Number, Object>(){

            public boolean test(Number key, Object value) {
                return false;
            }
        };
        new StreamsBuilder().stream("empty").filter((Predicate)numberKeyPredicate).filterNot((Predicate)numberKeyPredicate).to("nirvana");
    }
}

