/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.utils.MockTime;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class GlobalKTableIntegrationTest {
    private static final int NUM_BROKERS = 1;
    @ClassRule
    public static final EmbeddedKafkaCluster CLUSTER = new EmbeddedKafkaCluster(1);
    private static volatile int testNo = 0;
    private final MockTime mockTime;
    private final KeyValueMapper<String, Long, Long> keyMapper;
    private final ValueJoiner<Long, String, String> joiner;
    private final String globalStore = "globalStore";
    private final Map<String, String> results;
    private StreamsBuilder builder;
    private Properties streamsConfiguration;
    private KafkaStreams kafkaStreams;
    private String globalTableTopic;
    private String streamTopic;
    private GlobalKTable<Long, String> globalTable;
    private KStream<String, Long> stream;
    private ForeachAction<String, String> foreachAction;

    public GlobalKTableIntegrationTest() {
        this.mockTime = GlobalKTableIntegrationTest.CLUSTER.time;
        this.keyMapper = new KeyValueMapper<String, Long, Long>(){

            public Long apply(String key, Long value) {
                return value;
            }
        };
        this.joiner = new ValueJoiner<Long, String, String>(){

            public String apply(Long value1, String value2) {
                return value1 + "+" + value2;
            }
        };
        this.globalStore = "globalStore";
        this.results = new HashMap<String, String>();
    }

    @Before
    public void before() throws InterruptedException {
        this.builder = new StreamsBuilder();
        this.createTopics();
        this.streamsConfiguration = new Properties();
        String applicationId = "globalTableTopic-table-test-" + ++testNo;
        this.streamsConfiguration.put("application.id", applicationId);
        this.streamsConfiguration.put("bootstrap.servers", CLUSTER.bootstrapServers());
        this.streamsConfiguration.put("auto.offset.reset", "earliest");
        this.streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        this.streamsConfiguration.put("cache.max.bytes.buffering", (Object)0);
        this.streamsConfiguration.put("internal.leave.group.on.close", (Object)true);
        this.streamsConfiguration.put("commit.interval.ms", (Object)100);
        this.globalTable = this.builder.globalTable(this.globalTableTopic, Consumed.with((Serde)Serdes.Long(), (Serde)Serdes.String()), Materialized.as((String)"globalStore").withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()));
        Consumed stringLongConsumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Long());
        this.stream = this.builder.stream(this.streamTopic, stringLongConsumed);
        this.foreachAction = new ForeachAction<String, String>(){

            public void apply(String key, String value) {
                GlobalKTableIntegrationTest.this.results.put(key, value);
            }
        };
    }

    @After
    public void whenShuttingDown() throws IOException {
        if (this.kafkaStreams != null) {
            this.kafkaStreams.close();
        }
        IntegrationTestUtils.purgeLocalStreamsState(this.streamsConfiguration);
    }

    @Test
    public void shouldKStreamGlobalKTableLeftJoin() throws Exception {
        KStream streamTableJoin = this.stream.leftJoin(this.globalTable, this.keyMapper, this.joiner);
        streamTableJoin.foreach(this.foreachAction);
        this.produceInitialGlobalTableValues();
        this.startStreams();
        this.produceTopicValues(this.streamTopic);
        final HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "1+A");
        expected.put("b", "2+B");
        expected.put("c", "3+C");
        expected.put("d", "4+D");
        expected.put("e", "5+null");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for initial values");
        this.produceGlobalTableValues();
        final ReadOnlyKeyValueStore replicatedStore = (ReadOnlyKeyValueStore)this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return "J".equals(replicatedStore.get((Object)5L));
            }
        }, (long)30000L, (String)"waiting for data in replicated store");
        this.produceTopicValues(this.streamTopic);
        expected.put("a", "1+F");
        expected.put("b", "2+G");
        expected.put("c", "3+H");
        expected.put("d", "4+I");
        expected.put("e", "5+J");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for final values");
    }

    @Test
    public void shouldKStreamGlobalKTableJoin() throws Exception {
        KStream streamTableJoin = this.stream.join(this.globalTable, this.keyMapper, this.joiner);
        streamTableJoin.foreach(this.foreachAction);
        this.produceInitialGlobalTableValues();
        this.startStreams();
        this.produceTopicValues(this.streamTopic);
        final HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "1+A");
        expected.put("b", "2+B");
        expected.put("c", "3+C");
        expected.put("d", "4+D");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for initial values");
        this.produceGlobalTableValues();
        final ReadOnlyKeyValueStore replicatedStore = (ReadOnlyKeyValueStore)this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return "J".equals(replicatedStore.get((Object)5L));
            }
        }, (long)30000L, (String)"waiting for data in replicated store");
        this.produceTopicValues(this.streamTopic);
        expected.put("a", "1+F");
        expected.put("b", "2+G");
        expected.put("c", "3+H");
        expected.put("d", "4+I");
        expected.put("e", "5+J");
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return GlobalKTableIntegrationTest.this.results.equals(expected);
            }
        }, (long)30000L, (String)"waiting for final values");
    }

    @Test
    public void shouldRestoreGlobalInMemoryKTableOnRestart() throws Exception {
        this.builder = new StreamsBuilder();
        this.globalTable = this.builder.globalTable(this.globalTableTopic, Consumed.with((Serde)Serdes.Long(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"globalStore")));
        this.produceInitialGlobalTableValues();
        this.startStreams();
        ReadOnlyKeyValueStore store = (ReadOnlyKeyValueStore)this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
        Assert.assertThat((Object)store.approximateNumEntries(), (Matcher)IsEqual.equalTo((Object)4L));
        this.kafkaStreams.close();
        this.startStreams();
        store = (ReadOnlyKeyValueStore)this.kafkaStreams.store("globalStore", QueryableStoreTypes.keyValueStore());
        Assert.assertThat((Object)store.approximateNumEntries(), (Matcher)IsEqual.equalTo((Object)4L));
    }

    private void createTopics() throws InterruptedException {
        this.streamTopic = "stream-" + testNo;
        this.globalTableTopic = "globalTable-" + testNo;
        CLUSTER.createTopics(this.streamTopic);
        CLUSTER.createTopic(this.globalTableTopic, 2, 1);
    }

    private void startStreams() {
        this.kafkaStreams = new KafkaStreams(this.builder.build(), this.streamsConfiguration);
        this.kafkaStreams.start();
    }

    private void produceTopicValues(String topic) throws Exception {
        IntegrationTestUtils.produceKeyValuesSynchronously(topic, Arrays.asList(new KeyValue((Object)"a", (Object)1L), new KeyValue((Object)"b", (Object)2L), new KeyValue((Object)"c", (Object)3L), new KeyValue((Object)"d", (Object)4L), new KeyValue((Object)"e", (Object)5L)), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), StringSerializer.class, LongSerializer.class, (Properties)new Properties()), (Time)this.mockTime);
    }

    private void produceInitialGlobalTableValues() throws Exception {
        IntegrationTestUtils.produceKeyValuesSynchronously(this.globalTableTopic, Arrays.asList(new KeyValue((Object)1L, (Object)"A"), new KeyValue((Object)2L, (Object)"B"), new KeyValue((Object)3L, (Object)"C"), new KeyValue((Object)4L, (Object)"D")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), LongSerializer.class, StringSerializer.class), (Time)this.mockTime);
    }

    private void produceGlobalTableValues() throws Exception {
        IntegrationTestUtils.produceKeyValuesSynchronously(this.globalTableTopic, Arrays.asList(new KeyValue((Object)1L, (Object)"F"), new KeyValue((Object)2L, (Object)"G"), new KeyValue((Object)3L, (Object)"H"), new KeyValue((Object)4L, (Object)"I"), new KeyValue((Object)5L, (Object)"J")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), LongSerializer.class, StringSerializer.class, (Properties)new Properties()), (Time)this.mockTime);
    }
}

