/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.junit.Assert;

public class MockProcessorSupplier<K, V>
implements ProcessorSupplier<K, V> {
    public final ArrayList<String> processed = new ArrayList();
    public final ArrayList<K> processedKeys = new ArrayList();
    public final ArrayList<V> processedValues = new ArrayList();
    public final ArrayList<Long> punctuatedStreamTime = new ArrayList();
    public final ArrayList<Long> punctuatedSystemTime = new ArrayList();
    private final long scheduleInterval;
    private final PunctuationType punctuationType;
    public Cancellable scheduleCancellable;

    public MockProcessorSupplier() {
        this(-1L);
    }

    public MockProcessorSupplier(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockProcessorSupplier(long scheduleInterval, PunctuationType punctuationType) {
        this.scheduleInterval = scheduleInterval;
        this.punctuationType = punctuationType;
    }

    public Processor<K, V> get() {
        return new MockProcessor(this.punctuationType);
    }

    public void checkAndClearProcessResult(String ... expected) {
        Assert.assertEquals((String)("the number of outputs:" + this.processed), (long)expected.length, (long)this.processed.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("output[" + i + "]:"), (Object)expected[i], (Object)this.processed.get(i));
        }
        this.processed.clear();
    }

    public void checkEmptyAndClearProcessResult() {
        Assert.assertEquals((String)"the number of outputs:", (long)0L, (long)this.processed.size());
        this.processed.clear();
    }

    public void checkAndClearPunctuateResult(PunctuationType type, long ... expected) {
        ArrayList<Long> punctuated = type == PunctuationType.STREAM_TIME ? this.punctuatedStreamTime : this.punctuatedSystemTime;
        Assert.assertEquals((String)"the number of outputs:", (long)expected.length, (long)punctuated.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("output[" + i + "]:"), (long)expected[i], (long)punctuated.get(i));
        }
        this.processed.clear();
    }

    public class MockProcessor
    extends AbstractProcessor<K, V> {
        PunctuationType punctuationType;

        public MockProcessor(PunctuationType punctuationType) {
            this.punctuationType = punctuationType;
        }

        public void init(ProcessorContext context) {
            super.init(context);
            if (MockProcessorSupplier.this.scheduleInterval > 0L) {
                MockProcessorSupplier.this.scheduleCancellable = context.schedule(MockProcessorSupplier.this.scheduleInterval, this.punctuationType, new Punctuator(){

                    public void punctuate(long timestamp) {
                        if (MockProcessor.this.punctuationType == PunctuationType.STREAM_TIME) {
                            Assert.assertEquals((long)timestamp, (long)MockProcessor.this.context().timestamp());
                        }
                        Assert.assertEquals((long)-1L, (long)MockProcessor.this.context().partition());
                        Assert.assertEquals((long)-1L, (long)MockProcessor.this.context().offset());
                        (MockProcessor.this.punctuationType == PunctuationType.STREAM_TIME ? MockProcessorSupplier.this.punctuatedStreamTime : MockProcessorSupplier.this.punctuatedSystemTime).add(timestamp);
                    }
                });
            }
        }

        public void process(K key, V value) {
            MockProcessorSupplier.this.processedKeys.add(key);
            MockProcessorSupplier.this.processedValues.add(value);
            MockProcessorSupplier.this.processed.add((key == null ? "null" : key) + ":" + (value == null ? "null" : value));
        }
    }
}

