/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;

public class WindowKeySchemaTest {
    private final WindowKeySchema windowKeySchema = new WindowKeySchema();
    private DelegatingPeekingKeyValueIterator<Bytes, Integer> iterator;

    @Before
    public void before() {
        this.windowKeySchema.init("topic");
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)1), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(0L, 0L))), (Object)2), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)3), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(10L, 20L))), (Object)4), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)5), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)6));
        this.iterator = new DelegatingPeekingKeyValueIterator("foo", new KeyValueIteratorStub(keys.iterator()));
    }

    @Test
    public void testHasNextConditionUsingNullKeys() {
        HasNextCondition hasNextCondition = this.windowKeySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testUpperBoundWithLargeTimestamps() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, -113}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, -113, -97}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerAndSmallerThanFirstTimestampByte() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{12, 12, 9}), 0xAFFFFFFFFFFFFFFL);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{12, 12}, (long)0xAFFFFFFFFFFFFFFL, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{12, 12}, (long)0xAFFFFFFFFFFFFFFL, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithZeroTimestamp() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testLowerBoundWithZeroTimestamp() {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void testLowerBoundWithMonZeroTimestamp() {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 42L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void testLowerBoundMatchesTrailingZeros() {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0x7FFFFFFFFFFFFFFEL);
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (long)0x7FFFFFFFFFFFFFFEL, (int)0)) < 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowStoreUtils.toBinaryKey((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    private List<Integer> getValues(HasNextCondition hasNextCondition) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (hasNextCondition.hasNext(this.iterator)) {
            results.add((Integer)this.iterator.next().value);
        }
        return results;
    }
}

