/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;

public class SessionKeySchemaTest {
    private final SessionKeySchema sessionKeySchema = new SessionKeySchema();
    private DelegatingPeekingKeyValueIterator<Bytes, Integer> iterator;

    @Before
    public void before() {
        this.sessionKeySchema.init("topic");
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)1), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(0L, 0L))), (Object)2), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)3), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(10L, 20L))), (Object)4), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)5), KeyValue.pair((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)6));
        this.iterator = new DelegatingPeekingKeyValueIterator("foo", new KeyValueIteratorStub(keys.iterator()));
    }

    @Test
    public void shouldFetchExactKeysSkippingLongerKeys() {
        Bytes key = Bytes.wrap((byte[])new byte[]{0});
        List<Integer> result = this.getValues(this.sessionKeySchema.hasNextCondition(key, key, 0L, Long.MAX_VALUE));
        MatcherAssert.assertThat(result, (Matcher)IsEqual.equalTo(Arrays.asList(2, 4)));
    }

    @Test
    public void shouldFetchExactKeySkippingShorterKeys() {
        Bytes key = Bytes.wrap((byte[])new byte[]{0, 0});
        HasNextCondition hasNextCondition = this.sessionKeySchema.hasNextCondition(key, key, 0L, Long.MAX_VALUE);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 5)));
    }

    @Test
    public void shouldFetchAllKeysUsingNullKeys() {
        HasNextCondition hasNextCondition = this.sessionKeySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testUpperBoundWithLargeTimestamps() {
        Bytes upper = this.sessionKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte() {
        Bytes upper = this.sessionKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, -113}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, -113, -97}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
    }

    @Test
    public void testUpperBoundWithZeroTimestamp() {
        Bytes upper = this.sessionKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
    }

    @Test
    public void testLowerBoundWithZeroTimestamp() {
        Bytes lower = this.sessionKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
    }

    @Test
    public void testLowerBoundMatchesTrailingZeros() {
        Bytes lower = this.sessionKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) < 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)SessionKeySerde.bytesToBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
    }

    private List<Integer> getValues(HasNextCondition hasNextCondition) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (hasNextCondition.hasNext(this.iterator)) {
            results.add((Integer)this.iterator.next().value);
        }
        return results;
    }
}

