/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentsTest {
    private static final int NUM_SEGMENTS = 5;
    private MockProcessorContext context;
    private Segments segments;
    private long segmentInterval;
    private File stateDirectory;
    private String storeName = "test";
    private final int retentionPeriod = 240000;

    @Before
    public void createContext() {
        this.stateDirectory = TestUtils.tempDirectory();
        this.context = new MockProcessorContext(this.stateDirectory, Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        this.segments = new Segments(this.storeName, 240000L, 5);
        this.segmentInterval = Segments.segmentInterval((long)240000L, (int)5);
    }

    @After
    public void close() {
        this.context.close();
        this.segments.close();
    }

    @Test
    public void shouldGetSegmentIdsFromTimestamp() {
        Assert.assertEquals((long)0L, (long)this.segments.segmentId(0L));
        Assert.assertEquals((long)1L, (long)this.segments.segmentId(60000L));
        Assert.assertEquals((long)2L, (long)this.segments.segmentId(120000L));
        Assert.assertEquals((long)3L, (long)this.segments.segmentId(180000L));
    }

    @Test
    public void shouldBaseSegmentIntervalOnRetentionAndNumSegments() {
        Segments segments = new Segments("test", 480000L, 5);
        Assert.assertEquals((long)0L, (long)segments.segmentId(0L));
        Assert.assertEquals((long)0L, (long)segments.segmentId(60000L));
        Assert.assertEquals((long)1L, (long)segments.segmentId(120000L));
    }

    @Test
    public void shouldGetSegmentNameFromId() throws Exception {
        Assert.assertEquals((Object)"test.0", (Object)this.segments.segmentName(0L));
        Assert.assertEquals((Object)("test." + this.segmentInterval), (Object)this.segments.segmentName(1L));
        Assert.assertEquals((Object)("test." + 2L * this.segmentInterval), (Object)this.segments.segmentName(2L));
    }

    @Test
    public void shouldCreateSegments() {
        Segment segment1 = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment segment2 = this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Segment segment3 = this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test.0").isDirectory());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test." + this.segmentInterval).isDirectory());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test." + 2L * this.segmentInterval).isDirectory());
        Assert.assertEquals((Object)true, (Object)segment1.isOpen());
        Assert.assertEquals((Object)true, (Object)segment2.isOpen());
        Assert.assertEquals((Object)true, (Object)segment3.isOpen());
    }

    @Test
    public void shouldNotCreateSegmentThatIsAlreadyExpired() {
        this.segments.getOrCreateSegment(7L, (ProcessorContext)this.context);
        Assert.assertNull((Object)this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context));
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test.0").exists());
    }

    @Test
    public void shouldCleanupSegmentsThatHaveExpired() {
        Segment segment1 = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment segment2 = this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Segment segment3 = this.segments.getOrCreateSegment(7L, (ProcessorContext)this.context);
        Assert.assertFalse((boolean)segment1.isOpen());
        Assert.assertFalse((boolean)segment2.isOpen());
        Assert.assertTrue((boolean)segment3.isOpen());
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test.0").exists());
        Assert.assertFalse((boolean)new File(this.context.stateDir(), "test/test." + this.segmentInterval).exists());
        Assert.assertTrue((boolean)new File(this.context.stateDir(), "test/test." + 7L * this.segmentInterval).exists());
    }

    @Test
    public void shouldGetSegmentForTimestamp() {
        Segment segment = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Assert.assertEquals((Object)segment, (Object)this.segments.getSegmentForTimestamp(0L));
    }

    @Test
    public void shouldCloseAllOpenSegments() {
        Segment first = this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        Segment second = this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        Segment third = this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.close();
        Assert.assertFalse((boolean)first.isOpen());
        Assert.assertFalse((boolean)second.isOpen());
        Assert.assertFalse((boolean)third.isOpen());
    }

    @Test
    public void shouldOpenExistingSegments() {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        this.segments.close();
        this.segments = new Segments("test", 240000L, 5);
        this.segments.openExisting((ProcessorContext)this.context);
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(0L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(1L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(2L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(3L).isOpen());
        Assert.assertTrue((boolean)this.segments.getSegmentForTimestamp(4L).isOpen());
    }

    @Test
    public void shouldGetSegmentsWithinTimeRange() {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        List segments = this.segments.segments(0L, 120000L);
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((long)0L, (long)((Segment)segments.get((int)0)).id);
        Assert.assertEquals((long)1L, (long)((Segment)segments.get((int)1)).id);
        Assert.assertEquals((long)2L, (long)((Segment)segments.get((int)2)).id);
    }

    @Test
    public void shouldGetSegmentsWithinTimeRangeOutOfOrder() throws Exception {
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        List segments = this.segments.segments(0L, 120000L);
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((long)0L, (long)((Segment)segments.get((int)0)).id);
        Assert.assertEquals((long)1L, (long)((Segment)segments.get((int)1)).id);
        Assert.assertEquals((long)2L, (long)((Segment)segments.get((int)2)).id);
    }

    @Test
    public void shouldRollSegments() {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 1);
        this.segments.getOrCreateSegment(1L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 2);
        this.segments.getOrCreateSegment(2L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 3);
        this.segments.getOrCreateSegment(3L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 4);
        this.segments.getOrCreateSegment(4L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(0L, 5);
        this.segments.getOrCreateSegment(5L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(1L, 5);
        this.segments.getOrCreateSegment(6L, (ProcessorContext)this.context);
        this.verifyCorrectSegments(2L, 5);
    }

    @Test
    public void shouldUpdateSegmentFileNameFromOldDateFormatToNewFormat() throws Exception {
        int segmentId;
        String storeDirectoryPath = this.stateDirectory.getAbsolutePath() + File.separator + this.storeName;
        File storeDirectory = new File(storeDirectoryPath);
        storeDirectory.mkdirs();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File oldSegment = new File(storeDirectoryPath + File.separator + this.storeName + "-" + formatter.format(new Date((long)segmentId * this.segmentInterval)));
            oldSegment.createNewFile();
        }
        this.segments.openExisting((ProcessorContext)this.context);
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File newSegment = new File(storeDirectoryPath + File.separator + this.storeName + "." + segmentId * 60000);
            Assert.assertTrue((boolean)newSegment.exists());
        }
    }

    @Test
    public void shouldUpdateSegmentFileNameFromOldColonFormatToNewFormat() throws Exception {
        int segmentId;
        String storeDirectoryPath = this.stateDirectory.getAbsolutePath() + File.separator + this.storeName;
        File storeDirectory = new File(storeDirectoryPath);
        storeDirectory.mkdirs();
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File oldSegment = new File(storeDirectoryPath + File.separator + this.storeName + ":" + segmentId * 60000);
            oldSegment.createNewFile();
        }
        this.segments.openExisting((ProcessorContext)this.context);
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File newSegment = new File(storeDirectoryPath + File.separator + this.storeName + "." + segmentId * 60000);
            Assert.assertTrue((boolean)newSegment.exists());
        }
    }

    @Test
    public void shouldClearSegmentsOnClose() {
        this.segments.getOrCreateSegment(0L, (ProcessorContext)this.context);
        this.segments.close();
        MatcherAssert.assertThat((Object)this.segments.getSegmentForTimestamp(0L), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void verifyCorrectSegments(long first, int numSegments) {
        List result = this.segments.segments(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)numSegments, (long)result.size());
        for (int i = 0; i < numSegments; ++i) {
            Assert.assertEquals((long)((long)i + first), (long)((Segment)result.get((int)i)).id);
        }
    }
}

