/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentIteratorTest {
    private final Segment segmentOne = new Segment("one", "one", 0L);
    private final Segment segmentTwo = new Segment("two", "window", 1L);
    private final HasNextCondition hasNextCondition = new HasNextCondition(){

        public boolean hasNext(KeyValueIterator iterator) {
            return iterator.hasNext();
        }
    };
    private MockProcessorContext context;
    private SegmentIterator iterator = null;

    @Before
    public void before() {
        this.context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        this.segmentOne.openDB((ProcessorContext)this.context);
        this.segmentTwo.openDB((ProcessorContext)this.context);
        this.segmentOne.put(Bytes.wrap((byte[])"a".getBytes()), "1".getBytes());
        this.segmentOne.put(Bytes.wrap((byte[])"b".getBytes()), "2".getBytes());
        this.segmentTwo.put(Bytes.wrap((byte[])"c".getBytes()), "3".getBytes());
        this.segmentTwo.put(Bytes.wrap((byte[])"d".getBytes()), "4".getBytes());
    }

    @After
    public void closeSegments() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        this.segmentOne.close();
        this.segmentTwo.close();
        this.context.close();
    }

    @Test
    public void shouldIterateOverAllSegments() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"z".getBytes()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"a", (Object)"1"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"b", (Object)"2"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"c", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"c", (Object)"3"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"d", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"d", (Object)"4"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void shouldOnlyIterateOverSegmentsInRange() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"a", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"a", (Object)"1"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)"b", (Object)new String(this.iterator.peekNextKey().get()));
        Assert.assertEquals((Object)KeyValue.pair((Object)"b", (Object)"2"), this.toStringKeyValue((KeyValue<Bytes, byte[]>)this.iterator.next()));
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementOnPeekNextKeyIfNoNext() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"f".getBytes()), Bytes.wrap((byte[])"h".getBytes()));
        this.iterator.peekNextKey();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementOnNextIfNoNext() {
        this.iterator = new SegmentIterator(Arrays.asList(this.segmentOne, this.segmentTwo).iterator(), this.hasNextCondition, Bytes.wrap((byte[])"f".getBytes()), Bytes.wrap((byte[])"h".getBytes()));
        this.iterator.next();
    }

    private KeyValue<String, String> toStringKeyValue(KeyValue<Bytes, byte[]> binaryKv) {
        return KeyValue.pair((Object)new String(((Bytes)binaryKv.key).get()), (Object)new String((byte[])binaryKv.value));
    }
}

