/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SimpleTimeZone;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RocksDBSegmentedBytesStoreTest {
    private final long retention = 60000L;
    private final int numSegments = 3;
    private MockProcessorContext context;
    private final String storeName = "bytes-store";
    private RocksDBSegmentedBytesStore bytesStore;
    private File stateDir;
    private final SessionKeySchema schema = new SessionKeySchema();

    @Before
    public void before() {
        this.schema.init("topic");
        this.bytesStore = new RocksDBSegmentedBytesStore("bytes-store", 60000L, 3, (SegmentedBytesStore.KeySchema)this.schema);
        this.stateDir = TestUtils.tempDirectory();
        this.context = new MockProcessorContext(this.stateDir, Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        this.bytesStore.init((ProcessorContext)this.context, (StateStore)this.bytesStore);
    }

    @After
    public void close() {
        this.context.close();
        this.bytesStore.close();
    }

    @Test
    public void shouldPutAndFetch() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L))), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L))), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2000L))), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(2500L, 3000L))), this.serializeValue(200L));
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L)), (Object)50L));
        KeyValueIterator values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 1000L);
        Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
    }

    @Test
    public void shouldFindValuesWithinRange() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L))), this.serializeValue(10L));
        KeyValueIterator results = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 1L, 1999L);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)10L)), this.toList((KeyValueIterator<Bytes, byte[]>)results));
    }

    @Test
    public void shouldRemove() {
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L))), this.serializeValue(30L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L))), this.serializeValue(50L));
        this.bytesStore.remove(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L))));
        KeyValueIterator value = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 1000L);
        Assert.assertFalse((boolean)value.hasNext());
    }

    @Test
    public void shouldRollSegments() {
        Segments segments = new Segments("bytes-store", 60000L, 3);
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L))), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(61000L, 120000L))), this.serializeValue(200L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L), segments.segmentName(2L)}), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(121000L, 180000L))), this.serializeValue(300L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(1L), segments.segmentName(2L), segments.segmentName(3L)}), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(181000L, 240000L))), this.serializeValue(400L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(2L), segments.segmentName(3L), segments.segmentName(4L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 240000L));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(61000L, 120000L)), (Object)200L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(121000L, 180000L)), (Object)300L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(181000L, 240000L)), (Object)400L)), results);
    }

    @Test
    public void shouldGetAllSegments() {
        Segments segments = new Segments("bytes-store", 60000L, 3);
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L))), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(61000L, 120000L))), this.serializeValue(200L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L), segments.segmentName(2L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L)), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(61000L, 120000L)), (Object)200L)), results);
    }

    @Test
    public void shouldFetchAllSegments() {
        Segments segments = new Segments("bytes-store", 60000L, 3);
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L))), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(61000L, 120000L))), this.serializeValue(200L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L), segments.segmentName(2L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetchAll(0L, 60000L));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L)), (Object)100L)), results);
    }

    @Test
    public void shouldLoadSegementsWithOldStyleDateFormattedName() {
        Segments segments = new Segments("bytes-store", 60000L, 3);
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L))), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        Long segmentId = Long.parseLong(nameParts[1]);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String formatted = formatter.format(new Date(segmentId * Segments.segmentInterval((long)60000L, (int)3)));
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + "-" + formatted);
        Assert.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = new RocksDBSegmentedBytesStore("bytes-store", 60000L, 3, (SegmentedBytesStore.KeySchema)this.schema);
        this.bytesStore.init((ProcessorContext)this.context, (StateStore)this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L)), (Object)100L))));
    }

    @Test
    public void shouldLoadSegementsWithOldStyleColonFormattedName() {
        Segments segments = new Segments("bytes-store", 60000L, 3);
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L))), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + ":" + Long.parseLong(nameParts[1]));
        Assert.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = new RocksDBSegmentedBytesStore("bytes-store", 60000L, 3, (SegmentedBytesStore.KeySchema)this.schema);
        this.bytesStore.init((ProcessorContext)this.context, (StateStore)this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(30000L, 60000L)), (Object)100L))));
    }

    @Test
    public void shouldBeAbleToWriteToReInitializedStore() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
        this.bytesStore.close();
        this.bytesStore.init((ProcessorContext)this.context, (StateStore)this.bytesStore);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L))), this.serializeValue(50L));
    }

    private Set<String> segmentDirs() {
        File windowDir = new File(this.stateDir, "bytes-store");
        return new HashSet<String>(Arrays.asList(windowDir.list()));
    }

    private byte[] serializeValue(long value) {
        return Serdes.Long().serializer().serialize("", (Object)value);
    }

    private Bytes serializeKey(Windowed<String> key) {
        return SessionKeySerde.toBinary(key, (Serializer)Serdes.String().serializer(), (String)"dummy");
    }

    private List<KeyValue<Windowed<String>, Long>> toList(KeyValueIterator<Bytes, byte[]> iterator) {
        ArrayList<KeyValue<Windowed<String>, Long>> results = new ArrayList<KeyValue<Windowed<String>, Long>>();
        while (iterator.hasNext()) {
            KeyValue next = (KeyValue)iterator.next();
            KeyValue deserialized = KeyValue.pair((Object)SessionKeySerde.from((byte[])((Bytes)next.key).get(), (Deserializer)Serdes.String().deserializer(), (String)"dummy"), (Object)Serdes.Long().deserializer().deserialize("", (byte[])next.value));
            results.add((KeyValue<Windowed<String>, Long>)deserialized);
        }
        return results;
    }
}

