/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBKeyValueStoreSupplier;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RocksDBKeyValueStoreSupplierTest {
    private static final String STORE_NAME = "name";
    private final ThreadCache cache = new ThreadCache(new LogContext("test "), 1024L, (StreamsMetrics)new MockStreamsMetrics(new Metrics()));
    private final MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), new NoOpRecordCollector(), this.cache);
    private KeyValueStore<String, String> store;

    @After
    public void close() {
        this.context.close();
        this.store.close();
    }

    @Test
    public void shouldCreateLoggingEnabledStoreWhenStoreLogged() {
        this.store = this.createStore(true, false);
        final ArrayList logged = new ArrayList();
        NoOpRecordCollector collector = new NoOpRecordCollector(){

            @Override
            public <K, V> void send(String topic, K key, V value, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
                logged.add(new ProducerRecord(topic, partition, timestamp, key, value));
            }
        };
        MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), collector, this.cache);
        context.setTime(1L);
        this.store.init((ProcessorContext)context, this.store);
        this.store.put((Object)"a", (Object)"b");
        Assert.assertFalse((boolean)logged.isEmpty());
    }

    @Test
    public void shouldNotBeLoggingEnabledStoreWhenLoggingNotEnabled() {
        this.store = this.createStore(false, false);
        final ArrayList logged = new ArrayList();
        NoOpRecordCollector collector = new NoOpRecordCollector(){

            @Override
            public <K, V> void send(String topic, K key, V value, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
                logged.add(new ProducerRecord(topic, partition, timestamp, key, value));
            }
        };
        MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), collector, this.cache);
        context.setTime(1L);
        this.store.init((ProcessorContext)context, this.store);
        this.store.put((Object)"a", (Object)"b");
        Assert.assertTrue((boolean)logged.isEmpty());
    }

    @Test
    public void shouldHaveCachedKeyValueStoreWhenCachingEnabled() {
        this.store = this.createStore(false, true);
        this.store.init((ProcessorContext)this.context, this.store);
        this.context.setTime(1L);
        this.store.put((Object)"a", (Object)"b");
        this.store.put((Object)"b", (Object)"c");
        MatcherAssert.assertThat((Object)((WrappedStateStore)this.store).wrappedStore(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class)));
        MatcherAssert.assertThat((Object)this.cache.size(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void shouldReturnMeteredStoreWhenCachingAndLoggingDisabled() {
        this.store = this.createStore(false, false);
        MatcherAssert.assertThat(this.store, (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(MeteredKeyValueBytesStore.class)));
    }

    @Test
    public void shouldReturnMeteredStoreWhenCachingDisabled() {
        this.store = this.createStore(true, false);
        MatcherAssert.assertThat(this.store, (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(MeteredKeyValueBytesStore.class)));
    }

    @Test
    public void shouldHaveMeteredStoreWhenCached() {
        this.store = this.createStore(false, true);
        this.store.init((ProcessorContext)this.context, this.store);
        StreamsMetrics metrics = this.context.metrics();
        Assert.assertFalse((boolean)metrics.metrics().isEmpty());
    }

    @Test
    public void shouldHaveMeteredStoreWhenLogged() {
        this.store = this.createStore(true, false);
        this.store.init((ProcessorContext)this.context, this.store);
        StreamsMetrics metrics = this.context.metrics();
        Assert.assertFalse((boolean)metrics.metrics().isEmpty());
    }

    private KeyValueStore<String, String> createStore(boolean logged, boolean cached) {
        return new RocksDBKeyValueStoreSupplier(STORE_NAME, Serdes.String(), Serdes.String(), logged, Collections.EMPTY_MAP, cached).get();
    }
}

