/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class ReadOnlyWindowStoreStub<K, V>
implements ReadOnlyWindowStore<K, V>,
StateStore {
    private final long windowSize;
    private final Map<Long, NavigableMap<K, V>> data = new HashMap<Long, NavigableMap<K, V>>();
    private boolean open = true;

    public ReadOnlyWindowStoreStub(long windowSize) {
        this.windowSize = windowSize;
    }

    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeFrom; now <= timeTo; ++now) {
            Map kvMap = this.data.get(now);
            if (kvMap == null || !kvMap.containsKey(key)) continue;
            results.add(new KeyValue((Object)now, kvMap.get(key)));
        }
        return new TheWindowStoreIterator(results.iterator());
    }

    public KeyValueIterator<Windowed<K>, V> all() {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now : this.data.keySet()) {
            NavigableMap<K, V> kvMap = this.data.get(now);
            if (kvMap == null) continue;
            for (Map.Entry entry : kvMap.entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported in " + this.getClass().getName());
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now : this.data.keySet()) {
            NavigableMap<K, V> kvMap;
            if (now < timeFrom || now > timeTo || (kvMap = this.data.get(now)) == null) continue;
            for (Map.Entry entry : kvMap.entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported in " + this.getClass().getName());
            }
        };
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeFrom; now <= timeTo; ++now) {
            NavigableMap<K, V> kvMap = this.data.get(now);
            if (kvMap == null) continue;
            for (Map.Entry entry : kvMap.subMap(from, true, to, true).entrySet()) {
                results.add(new KeyValue((Object)new Windowed(entry.getKey(), (Window)new TimeWindow(now, now + this.windowSize)), entry.getValue()));
            }
        }
        final Iterator iterator = results.iterator();
        return new KeyValueIterator<Windowed<K>, V>(){

            public void close() {
            }

            public Windowed<K> peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public KeyValue<Windowed<K>, V> next() {
                return (KeyValue)iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported in " + this.getClass().getName());
            }
        };
    }

    public void put(K key, V value, long timestamp) {
        if (!this.data.containsKey(timestamp)) {
            this.data.put(timestamp, new TreeMap());
        }
        this.data.get(timestamp).put(key, value);
    }

    public String name() {
        return null;
    }

    public void init(ProcessorContext context, StateStore root) {
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    private class TheWindowStoreIterator<E>
    implements WindowStoreIterator<E> {
        private final Iterator<KeyValue<Long, E>> underlying;

        TheWindowStoreIterator(Iterator<KeyValue<Long, E>> underlying) {
            this.underlying = underlying;
        }

        public void close() {
        }

        public Long peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }

        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        public KeyValue<Long, E> next() {
            return this.underlying.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported in " + this.getClass().getName());
        }
    }
}

