/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryKeyValueLoggedStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context) {
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"my-store"), (Serde)context.keySerde(), (Serde)context.valueSerde()).withLoggingEnabled(Collections.singletonMap("retention.ms", "1000"));
        StateStore store = storeBuilder.build();
        store.init(context, store);
        return (KeyValueStore)store;
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"1"));
        entries.add(new KeyValue((Object)2, (Object)"2"));
        this.store.putAll(entries);
        Assert.assertEquals((Object)this.store.get((Object)1), (Object)"1");
        Assert.assertEquals((Object)this.store.get((Object)2), (Object)"2");
    }
}

