/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.IOException;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CachingKeyValueStoreTest;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ThreadCacheTest;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingWindowStoreTest {
    private static final int MAX_CACHE_SIZE_BYTES = 150;
    private static final long DEFAULT_TIMESTAMP = 10L;
    private static final Long WINDOW_SIZE = 10000L;
    private MockProcessorContext context;
    private RocksDBSegmentedBytesStore underlying;
    private CachingWindowStore<String, String> cachingStore;
    private CachingKeyValueStoreTest.CacheFlushListenerStub<Windowed<String>, String> cacheListener;
    private ThreadCache cache;
    private String topic;
    private WindowKeySchema keySchema;

    @Before
    public void setUp() {
        this.keySchema = new WindowKeySchema();
        int retention = 30000;
        int numSegments = 3;
        this.underlying = new RocksDBSegmentedBytesStore("test", 30000L, 3, (SegmentedBytesStore.KeySchema)this.keySchema);
        RocksDBWindowStore windowStore = new RocksDBWindowStore((SegmentedBytesStore)this.underlying, Serdes.Bytes(), Serdes.ByteArray(), false, WINDOW_SIZE.longValue());
        this.cacheListener = new CachingKeyValueStoreTest.CacheFlushListenerStub();
        this.cachingStore = new CachingWindowStore((WindowStore)windowStore, Serdes.String(), Serdes.String(), WINDOW_SIZE.longValue(), Segments.segmentInterval((long)30000L, (int)3));
        this.cachingStore.setFlushListener(this.cacheListener, false);
        this.cache = new ThreadCache(new LogContext("testCache "), 150L, (StreamsMetrics)new MockStreamsMetrics(new Metrics()));
        this.topic = "topic";
        this.context = new MockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext((RecordContext)new ProcessorRecordContext(10L, 0L, 0, this.topic));
        this.cachingStore.init((ProcessorContext)this.context, this.cachingStore);
    }

    @After
    public void closeStore() {
        this.context.close();
        this.cachingStore.close();
    }

    @Test
    public void shouldPutFetchFromCache() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("a"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("b"), CachingWindowStoreTest.bytesValue("b"));
        WindowStoreIterator a = this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), 10L, 10L);
        WindowStoreIterator b = this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("b"), 10L, 10L);
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)a.next()), 10L, "a");
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)b.next()), 10L, "b");
        Assert.assertFalse((boolean)a.hasNext());
        Assert.assertFalse((boolean)b.hasNext());
        Assert.assertEquals((long)2L, (long)this.cache.size());
    }

    private void verifyKeyValue(KeyValue<Long, byte[]> next, long expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)next.key, (Matcher)CoreMatchers.equalTo((Object)expectedKey));
        MatcherAssert.assertThat((Object)next.value, (Matcher)CoreMatchers.equalTo((Object)CachingWindowStoreTest.bytesValue(expectedValue)));
    }

    private static byte[] bytesValue(String value) {
        return value.getBytes();
    }

    private static Bytes bytesKey(String key) {
        return Bytes.wrap((byte[])key.getBytes());
    }

    @Test
    public void shouldPutFetchRangeFromCache() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("a"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("b"), CachingWindowStoreTest.bytesValue("b"));
        KeyValueIterator iterator = this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesKey("b"), 10L, 10L);
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "a");
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "b");
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)2L, (long)this.cache.size());
    }

    @Test
    public void shouldGetAllFromCache() {
        String[] array;
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("a"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("b"), CachingWindowStoreTest.bytesValue("b"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("c"), CachingWindowStoreTest.bytesValue("c"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("d"), CachingWindowStoreTest.bytesValue("d"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("e"), CachingWindowStoreTest.bytesValue("e"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("f"), CachingWindowStoreTest.bytesValue("f"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("g"), CachingWindowStoreTest.bytesValue("g"));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("h"), CachingWindowStoreTest.bytesValue("h"));
        KeyValueIterator iterator = this.cachingStore.all();
        for (String s : array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"}) {
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingWindowStoreTest.bytesKey(s), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), s);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldFetchAllWithinTimestampRange() {
        String[] array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        for (int i = 0; i < array.length; ++i) {
            this.context.setTime(i);
            this.cachingStore.put(CachingWindowStoreTest.bytesKey(array[i]), CachingWindowStoreTest.bytesValue(array[i]));
        }
        KeyValueIterator iterator = this.cachingStore.fetchAll(0L, 7L);
        for (int i = 0; i < array.length; ++i) {
            String str = array[i];
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        KeyValueIterator iterator1 = this.cachingStore.fetchAll(2L, 4L);
        for (int i = 2; i <= 4; ++i) {
            String str = array[i];
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator1.next()), (Windowed<Bytes>)new Windowed((Object)CachingWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
        }
        Assert.assertFalse((boolean)iterator1.hasNext());
        KeyValueIterator iterator2 = this.cachingStore.fetchAll(5L, 7L);
        for (int i = 5; i <= 7; ++i) {
            String str = array[i];
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator2.next()), (Windowed<Bytes>)new Windowed((Object)CachingWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
        }
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    @Test
    public void shouldFlushEvictedItemsIntoUnderlyingStore() throws IOException {
        int added = this.addItemsToCache();
        KeyValueIterator iter = this.underlying.fetch(Bytes.wrap((byte[])"0".getBytes()), 10L, 10L);
        KeyValue next = (KeyValue)iter.next();
        Assert.assertEquals((long)10L, (long)this.keySchema.segmentTimestamp((Bytes)next.key));
        Assert.assertArrayEquals((byte[])"0".getBytes(), (byte[])((byte[])next.value));
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)(added - 1), (long)this.cache.size());
    }

    @Test
    public void shouldForwardDirtyItemsWhenFlushCalled() {
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("a"));
        this.cachingStore.flush();
        Assert.assertEquals((Object)"a", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assert.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
    }

    @Test
    public void shouldForwardOldValuesWhenEnabled() {
        this.cachingStore.setFlushListener(this.cacheListener, true);
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("a"));
        this.cachingStore.flush();
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("b"));
        this.cachingStore.flush();
        Assert.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assert.assertEquals((Object)"a", (Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
    }

    @Test
    public void shouldForwardOldValuesWhenDisabled() {
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("a"));
        this.cachingStore.flush();
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("b"));
        this.cachingStore.flush();
        Assert.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assert.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
    }

    @Test
    public void shouldForwardDirtyItemToListenerWhenEvicted() throws IOException {
        int numRecords = this.addItemsToCache();
        Assert.assertEquals((long)numRecords, (long)this.cacheListener.forwarded.size());
    }

    @Test
    public void shouldTakeValueFromCacheIfSameTimestampFlushedToRocks() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.flush();
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("b"), 10L);
        WindowStoreIterator fetch = this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("1"), 10L, 10L);
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "b");
        Assert.assertFalse((boolean)fetch.hasNext());
    }

    @Test
    public void shouldIterateAcrossWindows() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("1"), CachingWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        WindowStoreIterator fetch = this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("1"), 10L, 10L + WINDOW_SIZE);
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
        Assert.assertFalse((boolean)fetch.hasNext());
    }

    @Test
    public void shouldIterateCacheAndStore() {
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.underlying.put(WindowStoreUtils.toBinaryKey((Object)key, (long)10L, (int)0, (StateSerdes)WindowStoreUtils.getInnerStateSerde((String)"app-id")), "a".getBytes());
        this.cachingStore.put(key, CachingWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        WindowStoreIterator fetch = this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("1"), 10L, 10L + WINDOW_SIZE);
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
        this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
        Assert.assertFalse((boolean)fetch.hasNext());
    }

    @Test
    public void shouldIterateCacheAndStoreKeyRange() {
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.underlying.put(WindowStoreUtils.toBinaryKey((Object)key, (long)10L, (int)0, (StateSerdes)WindowStoreUtils.getInnerStateSerde((String)"app-id")), "a".getBytes());
        this.cachingStore.put(key, CachingWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        KeyValueIterator fetchRange = this.cachingStore.fetch(key, CachingWindowStoreTest.bytesKey("2"), 10L, 10L + WINDOW_SIZE);
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "a");
        StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L + WINDOW_SIZE, 10L + WINDOW_SIZE + WINDOW_SIZE)), "b");
        Assert.assertFalse((boolean)fetchRange.hasNext());
    }

    @Test
    public void shouldClearNamespaceCacheOnClose() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("a"));
        Assert.assertEquals((long)1L, (long)this.cache.size());
        this.cachingStore.close();
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToFetchFromClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), 0L, 10L);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToFetchRangeFromClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesKey("b"), 0L, 10L);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowIfTryingToWriteToClosedCachingStore() {
        this.cachingStore.close();
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("a"));
    }

    @Test
    public void shouldFetchAndIterateOverExactKeys() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("aa"), CachingWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("aa"), CachingWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("0005"), 60000L);
        List expected = Utils.mkList((Object[])new KeyValue[]{KeyValue.pair((Object)0L, (Object)CachingWindowStoreTest.bytesValue("0001")), KeyValue.pair((Object)1L, (Object)CachingWindowStoreTest.bytesValue("0003")), KeyValue.pair((Object)60000L, (Object)CachingWindowStoreTest.bytesValue("0005"))});
        List actual = StreamsTestUtils.toList(this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), 0L, Long.MAX_VALUE));
        StreamsTestUtils.verifyKeyValueList(expected, actual);
    }

    @Test
    public void shouldFetchAndIterateOverKeyRange() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("aa"), CachingWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("aa"), CachingWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesValue("0005"), 60000L);
        StreamsTestUtils.verifyKeyValueList(Utils.mkList((Object[])new KeyValue[]{CachingWindowStoreTest.windowedPair("a", "0001", 0L), CachingWindowStoreTest.windowedPair("a", "0003", 1L), CachingWindowStoreTest.windowedPair("a", "0005", 60000L)}), StreamsTestUtils.toList(this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesKey("a"), 0L, Long.MAX_VALUE)));
        StreamsTestUtils.verifyKeyValueList(Utils.mkList((Object[])new KeyValue[]{CachingWindowStoreTest.windowedPair("aa", "0002", 0L), CachingWindowStoreTest.windowedPair("aa", "0004", 1L)}), StreamsTestUtils.toList(this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("aa"), CachingWindowStoreTest.bytesKey("aa"), 0L, Long.MAX_VALUE)));
        StreamsTestUtils.verifyKeyValueList(Utils.mkList((Object[])new KeyValue[]{CachingWindowStoreTest.windowedPair("a", "0001", 0L), CachingWindowStoreTest.windowedPair("a", "0003", 1L), CachingWindowStoreTest.windowedPair("aa", "0002", 0L), CachingWindowStoreTest.windowedPair("aa", "0004", 1L), CachingWindowStoreTest.windowedPair("a", "0005", 60000L)}), StreamsTestUtils.toList(this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("a"), CachingWindowStoreTest.bytesKey("aa"), 0L, Long.MAX_VALUE)));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.cachingStore.put(null, CachingWindowStoreTest.bytesValue("anyValue"));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.cachingStore.put(CachingWindowStoreTest.bytesKey("a"), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        this.cachingStore.fetch(null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        this.cachingStore.fetch(null, CachingWindowStoreTest.bytesKey("anyTo"), 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        this.cachingStore.fetch(CachingWindowStoreTest.bytesKey("anyFrom"), null, 1L, 2L);
    }

    private static KeyValue<Windowed<Bytes>, byte[]> windowedPair(String key, String value, long timestamp) {
        return KeyValue.pair((Object)new Windowed((Object)CachingWindowStoreTest.bytesKey(key), (Window)new TimeWindow(timestamp, timestamp + WINDOW_SIZE)), (Object)CachingWindowStoreTest.bytesValue(value));
    }

    private int addItemsToCache() throws IOException {
        String kv;
        int i = 0;
        for (int cachedSize = 0; cachedSize < 150; cachedSize += ThreadCacheTest.memoryCacheEntrySize(kv.getBytes(), kv.getBytes(), this.topic) + 8 + 4) {
            kv = String.valueOf(i++);
            this.cachingStore.put(CachingWindowStoreTest.bytesKey(kv), CachingWindowStoreTest.bytesValue(kv));
        }
        return i;
    }
}

