/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.StateSerdes;
import org.junit.Assert;
import org.junit.Test;

public class StateSerdesTest {
    @Test(expected=NullPointerException.class)
    public void shouldThrowIfTopicNameIsNullForBuiltinTypes() {
        StateSerdes.withBuiltinTypes(null, byte[].class, byte[].class);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfKeyClassIsNullForBuiltinTypes() {
        StateSerdes.withBuiltinTypes((String)"anyName", null, byte[].class);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfValueClassIsNullForBuiltinTypes() {
        StateSerdes.withBuiltinTypes((String)"anyName", byte[].class, null);
    }

    @Test
    public void shouldReturnSerdesForBuiltInKeyAndValueTypesForBuiltinTypes() {
        Class[] supportedBuildInTypes;
        for (Class keyClass : supportedBuildInTypes = new Class[]{String.class, Short.class, Integer.class, Long.class, Float.class, Double.class, byte[].class, ByteBuffer.class, Bytes.class}) {
            for (Class valueClass : supportedBuildInTypes) {
                Assert.assertNotNull((Object)StateSerdes.withBuiltinTypes((String)"anyName", (Class)keyClass, (Class)valueClass));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownKeyTypeForBuiltinTypes() {
        StateSerdes.withBuiltinTypes((String)"anyName", Class.class, byte[].class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownValueTypeForBuiltinTypes() {
        StateSerdes.withBuiltinTypes((String)"anyName", byte[].class, Class.class);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfTopicNameIsNull() {
        new StateSerdes(null, Serdes.ByteArray(), Serdes.ByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfKeyClassIsNull() {
        new StateSerdes("anyName", null, Serdes.ByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfValueClassIsNull() {
        new StateSerdes("anyName", Serdes.ByteArray(), null);
    }
}

