/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.processor.internals.RecordContextStub;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.StateManagerStub;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockStateStore;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractProcessorContextTest {
    private final MockStreamsMetrics metrics = new MockStreamsMetrics(new Metrics());
    private final AbstractProcessorContext context = new TestProcessorContext(this.metrics);
    private final MockStateStore stateStore = new MockStateStore("store", false);
    private final RecordContext recordContext = new RecordContextStub(10L, System.currentTimeMillis(), 1, "foo");

    @Before
    public void before() {
        this.context.setRecordContext(this.recordContext);
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnRegisterWhenContextIsInitialized() {
        this.context.initialized();
        try {
            this.context.register((StateStore)this.stateStore, false, null);
            Assert.fail((String)"should throw illegal state exception when context already initialized");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotThrowIllegalStateExceptionOnRegisterWhenContextIsNotInitialized() {
        this.context.register((StateStore)this.stateStore, false, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnRegisterIfStateStoreIsNull() {
        this.context.register(null, false, null);
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnTopicIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.topic();
            Assert.fail((String)"should throw illegal state exception when record context is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnTopicFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.topic()));
    }

    @Test
    public void shouldReturnNullIfTopicEqualsNonExistTopic() {
        this.context.setRecordContext((RecordContext)new RecordContextStub(0L, 0L, 0, "__null_topic__"));
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnPartitionIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.partition();
            Assert.fail((String)"should throw illegal state exception when record context is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnPartitionFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.partition(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.partition()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnOffsetIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.offset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnOffsetFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.offset(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.offset()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnTimestampIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.timestamp();
            Assert.fail((String)"should throw illegal state exception when record context is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnTimestampFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.timestamp()));
    }

    @Test
    public void appConfigsShouldReturnParsedValues() {
        MatcherAssert.assertThat((Object)((Class)this.context.appConfigs().get("rocksdb.config.setter")), (Matcher)CoreMatchers.equalTo(RocksDBConfigSetter.class));
    }

    @Test
    public void appConfigsShouldReturnUnrecognizedValues() {
        MatcherAssert.assertThat((Object)((String)this.context.appConfigs().get("user.supplied.config")), (Matcher)CoreMatchers.equalTo((Object)"user-suppplied-value"));
    }

    private static class TestProcessorContext
    extends AbstractProcessorContext {
        static Properties config = StreamsTestUtils.minimalStreamsConfig();

        TestProcessorContext(MockStreamsMetrics metrics) {
            super(new TaskId(0, 0), new StreamsConfig((Map)config), (StreamsMetrics)metrics, (StateManager)new StateManagerStub(), new ThreadCache(new LogContext("name "), 0L, (StreamsMetrics)metrics));
        }

        public StateStore getStateStore(String name) {
            return null;
        }

        public Cancellable schedule(long interval, PunctuationType type, Punctuator callback) {
            return null;
        }

        public void schedule(long interval) {
        }

        public <K, V> void forward(K key, V value) {
        }

        public <K, V> void forward(K key, V value, int childIndex) {
        }

        public <K, V> void forward(K key, V value, String childName) {
        }

        public void commit() {
        }

        static {
            config.put("rocksdb.config.setter", RocksDBConfigSetter.class.getName());
            config.put("user.supplied.config", "user-suppplied-value");
        }
    }
}

