/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.junit.Assert;
import org.junit.Test;

public class SessionKeySerdeTest {
    private final String topic = "topic";
    private final String key = "key";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Window window = new SessionWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed((Object)"key", this.window);
    private final Serde<String> serde = Serdes.String();
    private final SessionKeySerde<String> sessionKeySerde = new SessionKeySerde(this.serde);

    @Test
    public void shouldSerializeDeserialize() {
        byte[] bytes = this.sessionKeySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = (Windowed)this.sessionKeySerde.deserializer().deserialize("topic", bytes);
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldSerializeNullToNull() {
        Assert.assertNull((Object)this.sessionKeySerde.serializer().serialize("topic", null));
    }

    @Test
    public void shouldDeSerializeEmtpyByteArrayToNull() {
        Assert.assertNull((Object)this.sessionKeySerde.deserializer().deserialize("topic", new byte[0]));
    }

    @Test
    public void shouldDeSerializeNullToNull() {
        Assert.assertNull((Object)this.sessionKeySerde.deserializer().deserialize("topic", null));
    }

    @Test
    public void shouldConvertToBinaryAndBack() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Windowed result = SessionKeySerde.from((byte[])serialized.get(), (Deserializer)Serdes.String().deserializer(), (String)"dummy");
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldExtractEndTimeFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals((long)100L, (long)SessionKeySerde.extractEnd((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractStartTimeFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals((long)50L, (long)SessionKeySerde.extractStart((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractWindowFromBindary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals((Object)this.window, (Object)SessionKeySerde.extractWindow((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertArrayEquals((byte[])"key".getBytes(), (byte[])SessionKeySerde.extractKeyBytes((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractKeyFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals(this.windowedKey, (Object)SessionKeySerde.from((byte[])serialized.get(), (Deserializer)this.serde.deserializer(), (String)"dummy"));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() {
        Bytes bytesKey = Bytes.wrap((byte[])"key".getBytes());
        Windowed windowedBytesKey = new Windowed((Object)bytesKey, this.window);
        Bytes serialized = SessionKeySerde.bytesToBinary((Windowed)windowedBytesKey);
        Assert.assertEquals((Object)windowedBytesKey, (Object)SessionKeySerde.fromBytes((Bytes)serialized));
    }
}

