/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KTableMapValuesTest {
    private final Serde<String> stringSerde = Serdes.String();
    private final Consumed<String, String> consumed = Consumed.with(this.stringSerde, this.stringSerde);
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();
    private File stateDir = null;

    @Before
    public void setUp() {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    private void doTestKTable(StreamsBuilder builder, String topic1, MockProcessorSupplier<String, Integer> proc2) {
        this.driver.setUp(builder, this.stateDir, Serdes.String(), Serdes.String());
        this.driver.process(topic1, "A", "1");
        this.driver.process(topic1, "B", "2");
        this.driver.process(topic1, "C", "3");
        this.driver.process(topic1, "D", "4");
        this.driver.flushState();
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:1", "B:2", "C:3", "D:4"}), proc2.processed);
    }

    @Test
    public void testKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table(topic1, this.consumed);
        KTable table2 = table1.mapValues((ValueMapper)new ValueMapper<CharSequence, Integer>(){

            public Integer apply(CharSequence value) {
                return value.charAt(0) - 48;
            }
        });
        MockProcessorSupplier<String, Integer> proc2 = new MockProcessorSupplier<String, Integer>();
        table2.toStream().process(proc2, new String[0]);
        this.doTestKTable(builder, topic1, proc2);
    }

    @Test
    public void testQueryableKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table(topic1, this.consumed);
        KTable table2 = table1.mapValues((ValueMapper)new ValueMapper<CharSequence, Integer>(){

            public Integer apply(CharSequence value) {
                return value.charAt(0) - 48;
            }
        }, Materialized.as((String)"anyName").withValueSerde(Serdes.Integer()));
        MockProcessorSupplier<String, Integer> proc2 = new MockProcessorSupplier<String, Integer>();
        table2.toStream().process(proc2, new String[0]);
        this.doTestKTable(builder, topic1, proc2);
    }

    private void doTestValueGetter(StreamsBuilder builder, String topic1, KTableImpl<String, String, String> table1, KTableImpl<String, String, Integer> table2, KTableImpl<String, Integer, Integer> table3, KTableImpl<String, String, String> table4) {
        KTableValueGetterSupplier getterSupplier1 = table1.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier2 = table2.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier3 = table3.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier4 = table4.valueGetterSupplier();
        this.driver.setUp(builder, this.stateDir, Serdes.String(), Serdes.String());
        KTableValueGetter getter1 = getterSupplier1.get();
        getter1.init(this.driver.context());
        KTableValueGetter getter2 = getterSupplier2.get();
        getter2.init(this.driver.context());
        KTableValueGetter getter3 = getterSupplier3.get();
        getter3.init(this.driver.context());
        KTableValueGetter getter4 = getterSupplier4.get();
        getter4.init(this.driver.context());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertNull((Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        Assert.assertEquals((Object)"03", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(3), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"03", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        Assert.assertNull((Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertNull((Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertNull((Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
    }

    @Test
    public void testValueGetter() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName2 = "storeName2";
        KTableImpl table1 = (KTableImpl)builder.table(topic1, this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KTableImpl table3 = (KTableImpl)table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        KTableImpl table4 = (KTableImpl)table1.through(this.stringSerde, this.stringSerde, topic2, storeName2);
        this.doTestValueGetter(builder, topic1, (KTableImpl<String, String, String>)table1, (KTableImpl<String, String, Integer>)table2, (KTableImpl<String, Integer, Integer>)table3, (KTableImpl<String, String, String>)table4);
    }

    @Test
    public void testQueryableValueGetter() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName2 = "storeName2";
        KTableImpl table1 = (KTableImpl)builder.table(topic1, this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        }, Materialized.as((String)"anyMapName").withValueSerde(Serdes.Integer()));
        KTableImpl table3 = (KTableImpl)table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        }, Materialized.as((String)"anyFilterName").withValueSerde(Serdes.Integer()));
        KTableImpl table4 = (KTableImpl)table1.through(this.stringSerde, this.stringSerde, topic2, storeName2);
        this.doTestValueGetter(builder, topic1, (KTableImpl<String, String, String>)table1, (KTableImpl<String, String, Integer>)table2, (KTableImpl<String, Integer, Integer>)table3, (KTableImpl<String, String, String>)table4);
    }

    @Test
    public void testNotSendingOldValue() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(topic1, this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.build().addProcessor("proc", proc, new String[]{table2.name});
        this.driver.setUp(builder, this.stateDir);
        Assert.assertFalse((boolean)table1.sendingOldValueEnabled());
        Assert.assertFalse((boolean)table2.sendingOldValueEnabled());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(1<-null)", "B:(1<-null)", "C:(1<-null)");
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(2<-null)", "B:(2<-null)");
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(3<-null)");
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(null<-null)");
    }

    @Test
    public void testSendingOldValue() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(topic1, this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        table2.enableSendingOldValues();
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.build().addProcessor("proc", proc, new String[]{table2.name});
        this.driver.setUp(builder, this.stateDir);
        Assert.assertTrue((boolean)table1.sendingOldValueEnabled());
        Assert.assertTrue((boolean)table2.sendingOldValueEnabled());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(1<-null)", "B:(1<-null)", "C:(1<-null)");
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(2<-1)", "B:(2<-1)");
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(3<-2)");
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(null<-3)");
    }
}

