/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsBuilderTest;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KTableKTableOuterJoinTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final String storeName1 = "store-name-1";
    private final String storeName2 = "store-name-2";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private File stateDir = null;
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();
    private final Consumed<Integer, String> consumed = Consumed.with(this.intSerde, this.stringSerde);

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testJoin() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = builder.table("topic2", this.consumed);
        KTable joined = table1.outerJoin(table2, MockValueJoiner.TOSTRING_JOINER);
        joined.toStream().process(processor, new String[0]);
        Collection<Set<String>> copartitionGroups = StreamsBuilderTest.getCopartitionedGroups(builder);
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        KTableValueGetterSupplier getterSupplier = ((KTableImpl)joined).valueGetterSupplier();
        this.driver.setUp(builder, this.stateDir);
        KTableValueGetter getter = getterSupplier.get();
        getter.init(this.driver.context());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.process("topic1", null, "SomeVal");
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+null", "1:X1+null");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+null"), this.kv(1, "X1+null"), this.kv(2, null), this.kv(3, null));
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.process("topic2", null, "AnotherVal");
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+Y0"), this.kv(1, "X1+Y1"), this.kv(2, null), this.kv(3, null));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1", "2:X2+null", "3:X3+null");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+Y0"), this.kv(1, "X1+Y1"), this.kv(2, "X2+null"), this.kv(3, "X3+null"));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+YY0", "1:X1+YY1", "2:X2+YY2", "3:X3+YY3");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+YY0"), this.kv(1, "X1+YY1"), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+YY0", "1:X1+YY1", "2:X2+YY2", "3:X3+YY3");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+YY0"), this.kv(1, "X1+YY1"), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (int i2 = 0; i2 < 2; ++i2) {
            this.driver.process("topic2", expectedKeys[i2], null);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+null", "1:X1+null");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+null"), this.kv(1, "X1+null"), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+null", "1:XX1+null", "2:XX2+YY2", "3:XX3+YY3");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "XX0+null"), this.kv(1, "XX1+null"), this.kv(2, "XX2+YY2"), this.kv(3, "XX3+YY3"));
        for (int i3 = 1; i3 < 3; ++i3) {
            this.driver.process("topic1", expectedKeys[i3], null);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("1:null", "2:null+YY2");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "XX0+null"), this.kv(1, null), this.kv(2, "null+YY2"), this.kv(3, "XX3+YY3"));
    }

    @Test
    public void testNotSendingOldValue() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = builder.table("topic2", this.consumed);
        KTable joined = table1.outerJoin(table2, MockValueJoiner.TOSTRING_JOINER);
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.build().addProcessor("proc", proc, new String[]{((KTableImpl)joined).name});
        this.driver.setUp(builder, this.stateDir);
        Assert.assertTrue((boolean)((KTableImpl)table1).sendingOldValueEnabled());
        Assert.assertTrue((boolean)((KTableImpl)table2).sendingOldValueEnabled());
        Assert.assertFalse((boolean)((KTableImpl)joined).sendingOldValueEnabled());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+null<-null)", "1:(X1+null<-null)");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-null)", "1:(X1+Y1<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-null)", "1:(X1+Y1<-null)", "2:(X2+null<-null)", "3:(X3+null<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-null)", "1:(X1+YY1<-null)", "2:(X2+YY2<-null)", "3:(X3+YY3<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-null)", "1:(X1+YY1<-null)", "2:(X2+YY2<-null)", "3:(X3+YY3<-null)");
        for (int i2 = 0; i2 < 2; ++i2) {
            this.driver.process("topic2", expectedKeys[i2], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+null<-null)", "1:(X1+null<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(XX0+null<-null)", "1:(XX1+null<-null)", "2:(XX2+YY2<-null)", "3:(XX3+YY3<-null)");
        for (int i3 = 1; i3 < 3; ++i3) {
            this.driver.process("topic1", expectedKeys[i3], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("1:(null<-null)", "2:(null+YY2<-null)");
    }

    @Test
    public void testSendingOldValue() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = builder.table("topic2", this.consumed);
        KTable joined = table1.outerJoin(table2, MockValueJoiner.TOSTRING_JOINER);
        ((KTableImpl)joined).enableSendingOldValues();
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.build().addProcessor("proc", proc, new String[]{((KTableImpl)joined).name});
        this.driver.setUp(builder, this.stateDir);
        Assert.assertTrue((boolean)((KTableImpl)table1).sendingOldValueEnabled());
        Assert.assertTrue((boolean)((KTableImpl)table2).sendingOldValueEnabled());
        Assert.assertTrue((boolean)((KTableImpl)joined).sendingOldValueEnabled());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+null<-null)", "1:(X1+null<-null)");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-X0+null)", "1:(X1+Y1<-X1+null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-X0+Y0)", "1:(X1+Y1<-X1+Y1)", "2:(X2+null<-null)", "3:(X3+null<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-X0+Y0)", "1:(X1+YY1<-X1+Y1)", "2:(X2+YY2<-X2+null)", "3:(X3+YY3<-X3+null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-X0+YY0)", "1:(X1+YY1<-X1+YY1)", "2:(X2+YY2<-X2+YY2)", "3:(X3+YY3<-X3+YY3)");
        for (int i2 = 0; i2 < 2; ++i2) {
            this.driver.process("topic2", expectedKeys[i2], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+null<-X0+YY0)", "1:(X1+null<-X1+YY1)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(XX0+null<-X0+null)", "1:(XX1+null<-X1+null)", "2:(XX2+YY2<-X2+YY2)", "3:(XX3+YY3<-X3+YY3)");
        for (int i3 = 1; i3 < 3; ++i3) {
            this.driver.process("topic1", expectedKeys[i3], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("1:(null<-XX1+null)", "2:(null+YY2<-XX2+YY2)");
    }

    private KeyValue<Integer, String> kv(Integer key, String value) {
        return new KeyValue((Object)key, (Object)value);
    }

    private void checkJoinedValues(KTableValueGetter<Integer, String> getter, KeyValue<Integer, String> ... expected) {
        for (KeyValue<Integer, String> kv : expected) {
            String value = (String)getter.get(kv.key);
            if (kv.value == null) {
                Assert.assertNull((Object)value);
                continue;
            }
            Assert.assertEquals((Object)kv.value, (Object)value);
        }
    }
}

