/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.test.KStreamTestDriver;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamPeekTest {
    private final String topicName = "topic";
    private final Serde<Integer> intSerd = Serdes.Integer();
    private final Serde<String> stringSerd = Serdes.String();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void shouldObserveStreamElements() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream("topic", Consumed.with(this.intSerd, this.stringSerd));
        ArrayList peekObserved = new ArrayList();
        ArrayList streamObserved = new ArrayList();
        stream.peek(KStreamPeekTest.collect(peekObserved)).foreach(KStreamPeekTest.collect(streamObserved));
        this.driver.setUp(builder);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        for (int key = 0; key < 32; ++key) {
            String value = "V" + key;
            this.driver.process("topic", key, value);
            expected.add(new KeyValue((Object)key, (Object)value));
        }
        Assert.assertEquals(expected, peekObserved);
        Assert.assertEquals(expected, streamObserved);
    }

    @Test
    public void shouldNotAllowNullAction() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream("topic", Consumed.with(this.intSerd, this.stringSerd));
        try {
            stream.peek(null);
            Assert.fail((String)"expected null action to throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static <K, V> ForeachAction<K, V> collect(final List<KeyValue<K, V>> into) {
        return new ForeachAction<K, V>(){

            public void apply(K key, V value) {
                into.add(new KeyValue(key, value));
            }
        };
    }
}

