/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.lang.reflect.Array;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamBranchTest {
    private String topicName = "topic";
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testKStreamBranch() {
        StreamsBuilder builder = new StreamsBuilder();
        Predicate<Integer, String> isEven = new Predicate<Integer, String>(){

            public boolean test(Integer key, String value) {
                return key % 2 == 0;
            }
        };
        Predicate<Integer, String> isMultipleOfThree = new Predicate<Integer, String>(){

            public boolean test(Integer key, String value) {
                return key % 3 == 0;
            }
        };
        Predicate<Integer, String> isOdd = new Predicate<Integer, String>(){

            public boolean test(Integer key, String value) {
                return key % 2 != 0;
            }
        };
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6};
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        KStream[] branches = stream.branch(new Predicate[]{isEven, isMultipleOfThree, isOdd});
        Assert.assertEquals((long)3L, (long)branches.length);
        MockProcessorSupplier[] processors = (MockProcessorSupplier[])Array.newInstance(MockProcessorSupplier.class, branches.length);
        for (int i = 0; i < branches.length; ++i) {
            processors[i] = new MockProcessorSupplier();
            branches[i].process((ProcessorSupplier)processors[i], new String[0]);
        }
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)3L, (long)processors[0].processed.size());
        Assert.assertEquals((long)1L, (long)processors[1].processed.size());
        Assert.assertEquals((long)2L, (long)processors[2].processed.size());
    }

    @Test
    public void testTypeVariance() {
        Predicate<Number, Object> positive = new Predicate<Number, Object>(){

            public boolean test(Number key, Object value) {
                return key.doubleValue() > 0.0;
            }
        };
        Predicate<Number, Object> negative = new Predicate<Number, Object>(){

            public boolean test(Number key, Object value) {
                return key.doubleValue() < 0.0;
            }
        };
        KStream[] branches = new StreamsBuilder().stream("empty").branch(new Predicate[]{positive, negative});
    }
}

