/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.MockMapper;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IntegrationTest.class})
@RunWith(value=Parameterized.class)
public class StreamStreamJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private KStream<Long, String> leftStream;
    private KStream<Long, String> rightStream;

    public StreamStreamJoinIntegrationTest(boolean cacheEnabled) {
        super(cacheEnabled);
    }

    @Before
    public void prepareTopology() throws InterruptedException {
        super.prepareEnvironment();
        appID = "stream-stream-join-integration-test";
        this.builder = new StreamsBuilder();
        this.leftStream = this.builder.stream("inputTopicLeft");
        this.rightStream = this.builder.stream("inputTopicRight");
    }

    @Test
    public void testInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        List<List<String>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList("A-a"), Collections.singletonList("B-a"), Arrays.asList("A-b", "B-b"), null, null, Arrays.asList("C-a", "C-b"), Arrays.asList("A-c", "B-c", "C-c"), null, null, null, Arrays.asList("A-d", "B-d", "C-d"), Arrays.asList("D-a", "D-b", "D-c", "D-d"));
        this.leftStream.join(this.rightStream, this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }

    @Test
    public void testInnerRepartitioned() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-repartitioned");
        List<List<String>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList("A-a"), Collections.singletonList("B-a"), Arrays.asList("A-b", "B-b"), null, null, Arrays.asList("C-a", "C-b"), Arrays.asList("A-c", "B-c", "C-c"), null, null, null, Arrays.asList("A-d", "B-d", "C-d"), Arrays.asList("D-a", "D-b", "D-c", "D-d"));
        this.leftStream.map(MockMapper.noOpKeyValueMapper()).join(this.rightStream.flatMap(MockMapper.noOpFlatKeyValueMapper()).selectKey(MockMapper.selectKeyKeyValueMapper()), this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }

    @Test
    public void testLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        List<List<String>> expectedResult = Arrays.asList(null, null, Collections.singletonList("A-null"), Collections.singletonList("A-a"), Collections.singletonList("B-a"), Arrays.asList("A-b", "B-b"), null, null, Arrays.asList("C-a", "C-b"), Arrays.asList("A-c", "B-c", "C-c"), null, null, null, Arrays.asList("A-d", "B-d", "C-d"), Arrays.asList("D-a", "D-b", "D-c", "D-d"));
        this.leftStream.leftJoin(this.rightStream, this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }

    @Test
    public void testLeftRepartitioned() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left-repartitioned");
        List<List<String>> expectedResult = Arrays.asList(null, null, Collections.singletonList("A-null"), Collections.singletonList("A-a"), Collections.singletonList("B-a"), Arrays.asList("A-b", "B-b"), null, null, Arrays.asList("C-a", "C-b"), Arrays.asList("A-c", "B-c", "C-c"), null, null, null, Arrays.asList("A-d", "B-d", "C-d"), Arrays.asList("D-a", "D-b", "D-c", "D-d"));
        this.leftStream.map(MockMapper.noOpKeyValueMapper()).leftJoin(this.rightStream.flatMap(MockMapper.noOpFlatKeyValueMapper()).selectKey(MockMapper.selectKeyKeyValueMapper()), this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }

    @Test
    public void testOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        List<List<String>> expectedResult = Arrays.asList(null, null, Collections.singletonList("A-null"), Collections.singletonList("A-a"), Collections.singletonList("B-a"), Arrays.asList("A-b", "B-b"), null, null, Arrays.asList("C-a", "C-b"), Arrays.asList("A-c", "B-c", "C-c"), null, null, null, Arrays.asList("A-d", "B-d", "C-d"), Arrays.asList("D-a", "D-b", "D-c", "D-d"));
        this.leftStream.outerJoin(this.rightStream, this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }

    @Test
    public void testOuterRepartitioned() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        List<List<String>> expectedResult = Arrays.asList(null, null, Collections.singletonList("A-null"), Collections.singletonList("A-a"), Collections.singletonList("B-a"), Arrays.asList("A-b", "B-b"), null, null, Arrays.asList("C-a", "C-b"), Arrays.asList("A-c", "B-c", "C-c"), null, null, null, Arrays.asList("A-d", "B-d", "C-d"), Arrays.asList("D-a", "D-b", "D-c", "D-d"));
        this.leftStream.map(MockMapper.noOpKeyValueMapper()).outerJoin(this.rightStream.flatMap(MockMapper.noOpFlatKeyValueMapper()).selectKey(MockMapper.selectKeyKeyValueMapper()), this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }

    @Test
    public void testMultiInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-multi-inner");
        List<List<String>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList("A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("A-b-a", "B-b-a", "A-a-b", "B-a-b", "A-b-b", "B-b-b"), null, null, Arrays.asList("C-a-a", "C-a-b", "C-b-a", "C-b-b"), Arrays.asList("A-c-a", "A-c-b", "B-c-a", "B-c-b", "C-c-a", "C-c-b", "A-a-c", "B-a-c", "A-b-c", "B-b-c", "C-a-c", "C-b-c", "A-c-c", "B-c-c", "C-c-c"), null, null, null, Arrays.asList("A-d-a", "A-d-b", "A-d-c", "B-d-a", "B-d-b", "B-d-c", "C-d-a", "C-d-b", "C-d-c", "A-a-d", "B-a-d", "A-b-d", "B-b-d", "C-a-d", "C-b-d", "A-c-d", "B-c-d", "C-c-d", "A-d-d", "B-d-d", "C-d-d"), Arrays.asList("D-a-a", "D-a-b", "D-a-c", "D-a-d", "D-b-a", "D-b-b", "D-b-c", "D-b-d", "D-c-a", "D-c-b", "D-c-c", "D-c-d", "D-d-a", "D-d-b", "D-d-c", "D-d-d"));
        this.leftStream.join(this.rightStream, this.valueJoiner, JoinWindows.of((long)10000L)).join(this.rightStream, this.valueJoiner, JoinWindows.of((long)10000L)).to("outputTopic");
        this.runTest(expectedResult);
    }
}

