/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;

public class MockStateStoreSupplier
implements StateStoreSupplier {
    private String name;
    private boolean persistent;
    private boolean loggingEnabled;
    private MockStateStore stateStore;

    public MockStateStoreSupplier(String name, boolean persistent) {
        this(name, persistent, true);
    }

    public MockStateStoreSupplier(String name, boolean persistent, boolean loggingEnabled) {
        this.name = name;
        this.persistent = persistent;
        this.loggingEnabled = loggingEnabled;
    }

    public MockStateStoreSupplier(MockStateStore stateStore) {
        this.stateStore = stateStore;
    }

    public String name() {
        return this.name;
    }

    public StateStore get() {
        if (this.stateStore != null) {
            return this.stateStore;
        }
        if (this.loggingEnabled) {
            return new MockStateStore(this.name, this.persistent).enableLogging();
        }
        return new MockStateStore(this.name, this.persistent);
    }

    public Map<String, String> logConfig() {
        return Collections.emptyMap();
    }

    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    public static class MockStateStore
    implements StateStore {
        private final String name;
        private final boolean persistent;
        public boolean loggingEnabled = false;
        public boolean initialized = false;
        public boolean flushed = false;
        public boolean closed = true;
        public final ArrayList<Integer> keys = new ArrayList();
        public final StateRestoreCallback stateRestoreCallback = new StateRestoreCallback(){
            private final Deserializer<Integer> deserializer = new IntegerDeserializer();

            public void restore(byte[] key, byte[] value) {
                MockStateStore.this.keys.add((Integer)this.deserializer.deserialize("", key));
            }
        };

        public MockStateStore(String name, boolean persistent) {
            this.name = name;
            this.persistent = persistent;
        }

        public MockStateStore enableLogging() {
            this.loggingEnabled = true;
            return this;
        }

        public String name() {
            return this.name;
        }

        public void init(ProcessorContext context, StateStore root) {
            context.register(root, this.loggingEnabled, this.stateRestoreCallback);
            this.initialized = true;
            this.closed = false;
        }

        public void flush() {
            this.flushed = true;
        }

        public void close() {
            this.closed = true;
        }

        public boolean persistent() {
            return this.persistent;
        }

        public boolean isOpen() {
            return !this.closed;
        }
    }
}

