/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryLRUCacheStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context, Class<K> keyClass, Class<V> valueClass, boolean useContextSerdes) {
        StateStoreSupplier supplier = useContextSerdes ? Stores.create((String)"my-store").withKeys(context.keySerde()).withValues(context.valueSerde()).inMemory().maxEntries(10).build() : Stores.create((String)"my-store").withKeys(keyClass).withValues(valueClass).inMemory().maxEntries(10).build();
        KeyValueStore store = (KeyValueStore)supplier.get();
        store.init(context, (StateStore)store);
        return store;
    }

    @Test
    public void testEvict() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)3, (Object)"three");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        this.store.put((Object)6, (Object)"six");
        this.store.put((Object)7, (Object)"seven");
        this.store.put((Object)8, (Object)"eight");
        this.store.put((Object)9, (Object)"nine");
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        this.store.put((Object)10, (Object)"ten");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((long)1L, (long)this.driver.numFlushedEntryRemoved());
        this.store.delete((Object)1);
        this.store.flush();
        Assert.assertEquals((long)9L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put((Object)11, (Object)"eleven");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put((Object)2, (Object)"two-again");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put((Object)12, (Object)"twelve");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(3));
        Assert.assertEquals((long)3L, (long)this.driver.numFlushedEntryRemoved());
    }
}

