/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.TaskAssignor;
import org.junit.Assert;
import org.junit.Test;

public class TaskAssignorTest {
    private static Map<Integer, ClientState<Integer>> copyStates(Map<Integer, ClientState<Integer>> states) {
        HashMap<Integer, ClientState<Integer>> copy = new HashMap<Integer, ClientState<Integer>>();
        for (Map.Entry<Integer, ClientState<Integer>> entry : states.entrySet()) {
            copy.put(entry.getKey(), (ClientState<Integer>)entry.getValue().copy());
        }
        return copy;
    }

    @Test
    public void testAssignWithoutStandby() {
        HashMap<Integer, ClientState<Integer>> statesWithNoPrevTasks = new HashMap<Integer, ClientState<Integer>>();
        for (int i = 0; i < 6; ++i) {
            statesWithNoPrevTasks.put(i, (ClientState<Integer>)new ClientState(1.0));
        }
        Map<Integer, ClientState<Integer>> states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        Set tasks = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
        TaskAssignor.assign(states, (Set)tasks, (int)0);
        int numActiveTasks = 0;
        int numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertEquals((long)1L, (long)assignment.activeTasks.size());
            Assert.assertEquals((long)1L, (long)assignment.assignedTasks.size());
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)tasks.size(), (long)numAssignedTasks);
        tasks = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7});
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)0);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((1 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((2 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 <= assignment.assignedTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((2 >= assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)tasks.size(), (long)numAssignedTasks);
        tasks = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3});
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)0);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((0 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((0 <= assignment.assignedTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)tasks.size(), (long)numAssignedTasks);
    }

    @Test
    public void testAssignWithStandby() {
        HashMap<Integer, ClientState<Integer>> statesWithNoPrevTasks = new HashMap<Integer, ClientState<Integer>>();
        for (int i = 0; i < 6; ++i) {
            statesWithNoPrevTasks.put(i, new ClientState(1.0));
        }
        Set tasks = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
        int numActiveTasks = 0;
        int numAssignedTasks = 0;
        Map<Integer, ClientState<Integer>> states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)1);
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertEquals((long)1L, (long)assignment.activeTasks.size());
            Assert.assertEquals((long)2L, (long)assignment.assignedTasks.size());
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)(tasks.size() * 2), (long)numAssignedTasks);
        tasks = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7});
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)1);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((1 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((2 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((2 <= assignment.assignedTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((3 >= assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)(tasks.size() * 2), (long)numAssignedTasks);
        tasks = Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3});
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)1);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((0 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 <= assignment.assignedTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((2 >= assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)(tasks.size() * 2), (long)numAssignedTasks);
        tasks = Utils.mkSet((Object[])new Integer[]{0, 1});
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)1);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((0 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((0 <= assignment.assignedTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)(tasks.size() * 2), (long)numAssignedTasks);
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)2);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((0 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 == assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)(tasks.size() * 3), (long)numAssignedTasks);
        states = TaskAssignorTest.copyStates(statesWithNoPrevTasks);
        TaskAssignor.assign(states, (Set)tasks, (int)3);
        numActiveTasks = 0;
        numAssignedTasks = 0;
        for (ClientState<Integer> assignment : states.values()) {
            numActiveTasks += assignment.activeTasks.size();
            numAssignedTasks += assignment.assignedTasks.size();
            Assert.assertTrue((0 <= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 >= assignment.activeTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((1 <= assignment.assignedTasks.size() ? 1 : 0) != 0);
            Assert.assertTrue((2 >= assignment.assignedTasks.size() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)tasks.size(), (long)numActiveTasks);
        Assert.assertEquals((long)(tasks.size() * 4), (long)numAssignedTasks);
    }

    @Test
    public void testStickiness() {
        Set newAssigned;
        Set newActive;
        Set oldAssigned;
        Set oldActive;
        int client;
        ClientState state;
        int task;
        List tasks = Utils.mkList((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
        Collections.shuffle(tasks);
        HashMap<Integer, Object> statesWithPrevTasks = new HashMap<Integer, ClientState<Integer>>();
        int i = 0;
        Iterator<Object> i$ = tasks.iterator();
        while (i$.hasNext()) {
            task = (Integer)i$.next();
            state = new ClientState(1.0);
            state.prevActiveTasks.add(task);
            state.prevAssignedTasks.add(task);
            statesWithPrevTasks.put(i++, (ClientState<Integer>)state);
        }
        Map<Integer, ClientState<Integer>> states = TaskAssignorTest.copyStates(statesWithPrevTasks);
        TaskAssignor.assign(states, (Set)Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5}), (int)0);
        i$ = states.keySet().iterator();
        while (i$.hasNext()) {
            client = (Integer)i$.next();
            oldActive = ((ClientState)statesWithPrevTasks.get((Object)Integer.valueOf((int)client))).prevActiveTasks;
            oldAssigned = ((ClientState)statesWithPrevTasks.get((Object)Integer.valueOf((int)client))).prevAssignedTasks;
            newActive = states.get((Object)Integer.valueOf((int)client)).activeTasks;
            newAssigned = states.get((Object)Integer.valueOf((int)client)).assignedTasks;
            Assert.assertEquals((Object)oldActive, (Object)newActive);
            Assert.assertEquals((Object)oldAssigned, (Object)newAssigned);
        }
        tasks = Utils.mkList((Object[])new Integer[]{0, 1, 2, 3, -1, -1});
        Collections.shuffle(tasks);
        statesWithPrevTasks = new HashMap();
        i = 0;
        i$ = tasks.iterator();
        while (i$.hasNext()) {
            task = (Integer)i$.next();
            state = new ClientState(1.0);
            if (task >= 0) {
                state.prevActiveTasks.add(task);
                state.prevAssignedTasks.add(task);
            }
            statesWithPrevTasks.put(i++, (ClientState<Integer>)state);
        }
        states = TaskAssignorTest.copyStates(statesWithPrevTasks);
        TaskAssignor.assign(states, (Set)Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3}), (int)0);
        i$ = states.keySet().iterator();
        while (i$.hasNext()) {
            client = (Integer)i$.next();
            oldActive = ((ClientState)statesWithPrevTasks.get((Object)Integer.valueOf((int)client))).prevActiveTasks;
            oldAssigned = ((ClientState)statesWithPrevTasks.get((Object)Integer.valueOf((int)client))).prevAssignedTasks;
            newActive = states.get((Object)Integer.valueOf((int)client)).activeTasks;
            newAssigned = states.get((Object)Integer.valueOf((int)client)).assignedTasks;
            Assert.assertEquals((Object)oldActive, (Object)newActive);
            Assert.assertEquals((Object)oldAssigned, (Object)newAssigned);
        }
        List taskSets = Utils.mkList((Object[])new Set[]{Utils.mkSet((Object[])new Integer[]{0, 1}), Utils.mkSet((Object[])new Integer[]{2, 3}), Utils.mkSet((Object[])new Integer[]{4, 5}), Utils.mkSet((Object[])new Integer[]{6, 7}), Utils.mkSet((Object[])new Integer[]{8, 9}), Utils.mkSet((Object[])new Integer[]{10, 11})});
        Collections.shuffle(taskSets);
        statesWithPrevTasks = new HashMap();
        i = 0;
        for (Set taskSet : taskSets) {
            ClientState state2 = new ClientState(1.0);
            state2.prevActiveTasks.addAll(taskSet);
            state2.prevAssignedTasks.addAll(taskSet);
            statesWithPrevTasks.put(i++, (ClientState<Integer>)state2);
        }
        states = TaskAssignorTest.copyStates(statesWithPrevTasks);
        TaskAssignor.assign(states, (Set)Utils.mkSet((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}), (int)0);
        Iterator<Object> i$2 = states.keySet().iterator();
        while (i$2.hasNext()) {
            int client2 = (Integer)i$2.next();
            Set oldActive2 = ((ClientState)statesWithPrevTasks.get((Object)Integer.valueOf((int)client2))).prevActiveTasks;
            Set oldAssigned2 = ((ClientState)statesWithPrevTasks.get((Object)Integer.valueOf((int)client2))).prevAssignedTasks;
            Set newActive2 = states.get((Object)Integer.valueOf((int)client2)).activeTasks;
            Set newAssigned2 = states.get((Object)Integer.valueOf((int)client2)).assignedTasks;
            HashSet intersection = new HashSet();
            intersection.addAll(oldActive2);
            intersection.retainAll(newActive2);
            Assert.assertTrue((intersection.size() > 0 ? 1 : 0) != 0);
            intersection.clear();
            intersection.addAll(oldAssigned2);
            intersection.retainAll(newAssigned2);
            Assert.assertTrue((intersection.size() > 0 ? 1 : 0) != 0);
        }
    }
}

