/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionInfoTest {
    @Test
    public void testEncodeDecode() {
        UUID processId = UUID.randomUUID();
        HashSet<TaskId> activeTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0)));
        HashSet<TaskId> standbyTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(1, 1), new TaskId(2, 0)));
        SubscriptionInfo info = new SubscriptionInfo(processId, activeTasks, standbyTasks, null);
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
        Assert.assertEquals((Object)info, (Object)decoded);
    }

    @Test
    public void shouldEncodeDecodeWithUserEndPoint() throws Exception {
        SubscriptionInfo original = new SubscriptionInfo(UUID.randomUUID(), Collections.singleton(new TaskId(0, 0)), Collections.emptySet(), "localhost:80");
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)original.encode());
        Assert.assertEquals((Object)original, (Object)decoded);
    }

    @Test
    public void shouldBeBackwardCompatible() throws Exception {
        UUID processId = UUID.randomUUID();
        HashSet<TaskId> activeTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0)));
        HashSet<TaskId> standbyTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(1, 1), new TaskId(2, 0)));
        ByteBuffer v1Encoding = this.encodePreviousVersion(processId, activeTasks, standbyTasks);
        SubscriptionInfo decode = SubscriptionInfo.decode((ByteBuffer)v1Encoding);
        Assert.assertEquals(activeTasks, (Object)decode.prevTasks);
        Assert.assertEquals(standbyTasks, (Object)decode.standbyTasks);
        Assert.assertEquals((Object)processId, (Object)decode.processId);
        Assert.assertNull((Object)decode.userEndPoint);
    }

    private ByteBuffer encodePreviousVersion(UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks) {
        ByteBuffer buf = ByteBuffer.allocate(24 + prevTasks.size() * 8 + 4 + standbyTasks.size() * 8);
        buf.putInt(1);
        buf.putLong(processId.getMostSignificantBits());
        buf.putLong(processId.getLeastSignificantBits());
        buf.putInt(prevTasks.size());
        for (TaskId id : prevTasks) {
            id.writeTo(buf);
        }
        buf.putInt(standbyTasks.size());
        for (TaskId id : standbyTasks) {
            id.writeTo(buf);
        }
        buf.rewind();
        return buf;
    }
}

