/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateDirectoryTest {
    private File stateDir;
    private String applicationId = "applicationId";
    private StateDirectory directory;
    private File appDir;

    @Before
    public void before() {
        this.stateDir = new File(TestUtils.IO_TMP_DIR, TestUtils.randomString((int)5));
        this.directory = new StateDirectory(this.applicationId, this.stateDir.getPath());
        this.appDir = new File(this.stateDir, this.applicationId);
    }

    @After
    public void cleanup() {
        if (this.stateDir.exists()) {
            Utils.delete((File)this.stateDir);
        }
    }

    @Test
    public void shouldCreateBaseDirectory() throws Exception {
        Assert.assertTrue((boolean)this.stateDir.exists());
        Assert.assertTrue((boolean)this.stateDir.isDirectory());
        Assert.assertTrue((boolean)this.appDir.exists());
        Assert.assertTrue((boolean)this.appDir.isDirectory());
    }

    @Test
    public void shouldCreateTaskStateDirectory() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        File taskDirectory = this.directory.directoryForTask(taskId);
        Assert.assertTrue((boolean)taskDirectory.exists());
        Assert.assertTrue((boolean)taskDirectory.isDirectory());
    }

    @Test
    public void shouldLockTaskStateDirectory() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        File taskDirectory = this.directory.directoryForTask(taskId);
        this.directory.lock(taskId, 0);
        FileChannel channel = FileChannel.open(new File(taskDirectory, ".lock").toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            channel.tryLock();
            Assert.fail((String)"shouldn't be able to lock already locked directory");
        }
        catch (OverlappingFileLockException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeTrueIfAlreadyHoldsLock() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        this.directory.directoryForTask(taskId);
        this.directory.lock(taskId, 0);
        Assert.assertTrue((boolean)this.directory.lock(taskId, 0));
    }

    @Test(expected=ProcessorStateException.class)
    public void shouldThrowProcessorStateException() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        Utils.delete((File)this.stateDir);
        this.directory.directoryForTask(taskId);
    }

    @Test
    public void shouldNotLockDeletedDirectory() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        Utils.delete((File)this.stateDir);
        Assert.assertFalse((boolean)this.directory.lock(taskId, 0));
    }

    @Test
    public void shouldLockMulitpleTaskDirectories() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        File task1Dir = this.directory.directoryForTask(taskId);
        TaskId taskId2 = new TaskId(1, 0);
        File task2Dir = this.directory.directoryForTask(taskId2);
        this.directory.lock(taskId, 0);
        this.directory.lock(taskId2, 0);
        FileChannel channel1 = FileChannel.open(new File(task1Dir, ".lock").toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        FileChannel channel2 = FileChannel.open(new File(task2Dir, ".lock").toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            channel1.tryLock();
            channel2.tryLock();
            Assert.fail((String)"shouldn't be able to lock already locked directory");
        }
        catch (OverlappingFileLockException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldReleaseTaskStateDirectoryLock() throws Exception {
        TaskId taskId = new TaskId(0, 0);
        File taskDirectory = this.directory.directoryForTask(taskId);
        this.directory.lock(taskId, 1);
        this.directory.unlock(taskId);
        FileChannel channel = FileChannel.open(new File(taskDirectory, ".lock").toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        channel.tryLock();
    }

    @Test
    public void shouldCleanUpTaskStateDirectoriesThatAreNotCurrentlyLocked() throws Exception {
        TaskId task0 = new TaskId(0, 0);
        TaskId task1 = new TaskId(1, 0);
        this.directory.lock(task0, 0);
        this.directory.lock(task1, 0);
        this.directory.directoryForTask(new TaskId(2, 0));
        this.directory.cleanRemovedTasks();
        List<File> files = Arrays.asList(this.appDir.listFiles());
        Assert.assertEquals((long)2L, (long)files.size());
        Assert.assertTrue((boolean)files.contains(new File(this.appDir, task0.toString())));
        Assert.assertTrue((boolean)files.contains(new File(this.appDir, task1.toString())));
    }

    @Test
    public void shouldNotRemoveNonTaskDirectoriesAndFiles() throws Exception {
        File otherDir = TestUtils.tempDirectory((Path)this.stateDir.toPath(), (String)"foo");
        this.directory.cleanRemovedTasks();
        Assert.assertTrue((boolean)otherDir.exists());
    }

    @Test
    public void shouldListAllTaskDirectories() throws Exception {
        TestUtils.tempDirectory((Path)this.stateDir.toPath(), (String)"foo");
        File taskDir1 = this.directory.directoryForTask(new TaskId(0, 0));
        File taskDir2 = this.directory.directoryForTask(new TaskId(0, 1));
        List<File> dirs = Arrays.asList(this.directory.listTaskDirectories());
        Assert.assertEquals((long)2L, (long)dirs.size());
        Assert.assertTrue((boolean)dirs.contains(taskDir1));
        Assert.assertTrue((boolean)dirs.contains(taskDir2));
    }

    @Test
    public void shouldCreateDirectoriesIfParentDoesntExist() throws Exception {
        File tempDir = TestUtils.tempDirectory();
        File stateDir = new File(new File(tempDir, "foo"), "state-dir");
        StateDirectory stateDirectory = new StateDirectory(this.applicationId, stateDir.getPath());
        File taskDir = stateDirectory.directoryForTask(new TaskId(0, 0));
        Assert.assertTrue((boolean)stateDir.exists());
        Assert.assertTrue((boolean)taskDir.exists());
    }

    @Test(expected=OverlappingFileLockException.class)
    public void shouldLockGlobalStateDirectory() throws Exception {
        FileChannel channel = FileChannel.open(new File(this.directory.globalStateDir(), ".lock").toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        this.directory.lockGlobalState(1);
        channel.lock();
    }

    @Test
    public void shouldUnlockGlobalStateDirectory() throws Exception {
        FileChannel channel = FileChannel.open(new File(this.directory.globalStateDir(), ".lock").toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        this.directory.lockGlobalState(1);
        this.directory.unlockGlobalState();
        channel.lock();
    }
}

