/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.junit.Assert;
import org.junit.Test;

public class SessionKeySerdeTest {
    @Test
    public void shouldSerializeDeserialize() throws Exception {
        Windowed key = new Windowed((Object)1L, (Window)new SessionWindow(10L, 100L));
        SessionKeySerde serde = new SessionKeySerde(Serdes.Long());
        byte[] bytes = serde.serializer().serialize("t", (Object)key);
        Windowed result = (Windowed)serde.deserializer().deserialize("t", bytes);
        Assert.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void shouldSerializeNullToNull() throws Exception {
        SessionKeySerde serde = new SessionKeySerde(Serdes.String());
        Assert.assertNull((Object)serde.serializer().serialize("t", null));
    }

    @Test
    public void shouldDeSerializeEmtpyByteArrayToNull() throws Exception {
        SessionKeySerde serde = new SessionKeySerde(Serdes.String());
        Assert.assertNull((Object)serde.deserializer().deserialize("t", new byte[0]));
    }

    @Test
    public void shouldDeSerializeNullToNull() throws Exception {
        SessionKeySerde serde = new SessionKeySerde(Serdes.String());
        Assert.assertNull((Object)serde.deserializer().deserialize("t", null));
    }

    @Test
    public void shouldConvertToBinaryAndBack() throws Exception {
        Windowed key = new Windowed((Object)"key", (Window)new SessionWindow(10L, 20L));
        Bytes serialized = SessionKeySerde.toBinary((Windowed)key, (Serializer)Serdes.String().serializer(), (String)"topic");
        Windowed result = SessionKeySerde.from((byte[])serialized.get(), (Deserializer)Serdes.String().deserializer(), (String)"topic");
        Assert.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void shouldExtractEndTimeFromBinary() throws Exception {
        Windowed key = new Windowed((Object)"key", (Window)new SessionWindow(10L, 100L));
        Bytes serialized = SessionKeySerde.toBinary((Windowed)key, (Serializer)Serdes.String().serializer(), (String)"topic");
        Assert.assertEquals((long)100L, (long)SessionKeySerde.extractEnd((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractStartTimeFromBinary() throws Exception {
        Windowed key = new Windowed((Object)"key", (Window)new SessionWindow(50L, 100L));
        Bytes serialized = SessionKeySerde.toBinary((Windowed)key, (Serializer)Serdes.String().serializer(), (String)"topic");
        Assert.assertEquals((long)50L, (long)SessionKeySerde.extractStart((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() throws Exception {
        Windowed key = new Windowed((Object)"blah", (Window)new SessionWindow(50L, 100L));
        Bytes serialized = SessionKeySerde.toBinary((Windowed)key, (Serializer)Serdes.String().serializer(), (String)"topic");
        Assert.assertArrayEquals((byte[])"blah".getBytes(), (byte[])SessionKeySerde.extractKeyBytes((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() throws Exception {
        Bytes bytesKey = Bytes.wrap((byte[])"key".getBytes());
        Windowed windowedBytesKey = new Windowed((Object)bytesKey, (Window)new SessionWindow(0L, 10L));
        Bytes serialized = SessionKeySerde.bytesToBinary((Windowed)windowedBytesKey);
        Assert.assertEquals((Object)windowedBytesKey, (Object)SessionKeySerde.fromBytes((Bytes)serialized));
    }
}

