/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamWindowAggregateTest {
    private final Serde<String> strSerde = Serdes.String();
    private KStreamTestDriver driver = null;
    private File stateDir = null;

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAggBasic() throws Exception {
        File baseDir = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        try {
            KStreamBuilder builder = new KStreamBuilder();
            String topic1 = "topic1";
            KStream stream1 = builder.stream(this.strSerde, this.strSerde, new String[]{topic1});
            KTable table2 = stream1.groupByKey(this.strSerde, this.strSerde).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, (Windows)TimeWindows.of((long)10L).advanceBy(5L), this.strSerde, "topic1-Canonized");
            MockProcessorSupplier proc2 = new MockProcessorSupplier();
            table2.toStream().process(proc2, new String[0]);
            this.driver = new KStreamTestDriver(builder, baseDir);
            this.setRecordContext(0L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            this.setRecordContext(1L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(2L, topic1);
            this.driver.process(topic1, "C", "3");
            this.driver.flushState();
            this.setRecordContext(3L, topic1);
            this.driver.process(topic1, "D", "4");
            this.driver.flushState();
            this.setRecordContext(4L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            this.setRecordContext(5L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            this.setRecordContext(6L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(7L, topic1);
            this.driver.process(topic1, "D", "4");
            this.driver.flushState();
            this.setRecordContext(8L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(9L, topic1);
            this.driver.process(topic1, "C", "3");
            this.driver.flushState();
            this.setRecordContext(10L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            this.setRecordContext(11L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(12L, topic1);
            this.driver.flushState();
            this.driver.process(topic1, "D", "4");
            this.driver.flushState();
            this.setRecordContext(13L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(14L, topic1);
            this.driver.process(topic1, "C", "3");
            this.driver.flushState();
            Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"[A@0]:0+1", "[B@0]:0+2", "[C@0]:0+3", "[D@0]:0+4", "[A@0]:0+1+1", "[A@0]:0+1+1+1", "[A@5]:0+1", "[B@0]:0+2+2", "[B@5]:0+2", "[D@0]:0+4+4", "[D@5]:0+4", "[B@0]:0+2+2+2", "[B@5]:0+2+2", "[C@0]:0+3+3", "[C@5]:0+3", "[A@5]:0+1+1", "[A@10]:0+1", "[B@5]:0+2+2+2", "[B@10]:0+2", "[D@5]:0+4+4", "[D@10]:0+4", "[B@5]:0+2+2+2+2", "[B@10]:0+2+2", "[C@5]:0+3+3", "[C@10]:0+3"}), proc2.processed);
        }
        finally {
            Utils.delete((File)baseDir);
        }
    }

    private void setRecordContext(long time, String topic) {
        ((MockProcessorContext)this.driver.context()).setRecordContext((RecordContext)new ProcessorRecordContext(time, 0L, 0, topic));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoin() throws Exception {
        File baseDir = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        try {
            KStreamBuilder builder = new KStreamBuilder();
            String topic1 = "topic1";
            String topic2 = "topic2";
            KStream stream1 = builder.stream(this.strSerde, this.strSerde, new String[]{topic1});
            KTable table1 = stream1.groupByKey(this.strSerde, this.strSerde).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, (Windows)TimeWindows.of((long)10L).advanceBy(5L), this.strSerde, "topic1-Canonized");
            MockProcessorSupplier proc1 = new MockProcessorSupplier();
            table1.toStream().process(proc1, new String[0]);
            KStream stream2 = builder.stream(this.strSerde, this.strSerde, new String[]{topic2});
            KTable table2 = stream2.groupByKey(this.strSerde, this.strSerde).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, (Windows)TimeWindows.of((long)10L).advanceBy(5L), this.strSerde, "topic2-Canonized");
            MockProcessorSupplier proc2 = new MockProcessorSupplier();
            table2.toStream().process(proc2, new String[0]);
            MockProcessorSupplier proc3 = new MockProcessorSupplier();
            table1.join(table2, (ValueJoiner)new ValueJoiner<String, String, String>(){

                public String apply(String p1, String p2) {
                    return p1 + "%" + p2;
                }
            }).toStream().process(proc3, new String[0]);
            this.driver = new KStreamTestDriver(builder, baseDir);
            this.setRecordContext(0L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            this.setRecordContext(1L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(2L, topic1);
            this.driver.process(topic1, "C", "3");
            this.driver.flushState();
            this.setRecordContext(3L, topic1);
            this.driver.process(topic1, "D", "4");
            this.driver.flushState();
            this.setRecordContext(4L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            proc1.checkAndClearProcessResult("[A@0]:0+1", "[B@0]:0+2", "[C@0]:0+3", "[D@0]:0+4", "[A@0]:0+1+1");
            proc2.checkAndClearProcessResult(new String[0]);
            proc3.checkAndClearProcessResult(new String[0]);
            this.setRecordContext(5L, topic1);
            this.driver.process(topic1, "A", "1");
            this.driver.flushState();
            this.setRecordContext(6L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(7L, topic1);
            this.driver.process(topic1, "D", "4");
            this.driver.flushState();
            this.setRecordContext(8L, topic1);
            this.driver.process(topic1, "B", "2");
            this.driver.flushState();
            this.setRecordContext(9L, topic1);
            this.driver.process(topic1, "C", "3");
            this.driver.flushState();
            proc1.checkAndClearProcessResult("[A@0]:0+1+1+1", "[A@5]:0+1", "[B@0]:0+2+2", "[B@5]:0+2", "[D@0]:0+4+4", "[D@5]:0+4", "[B@0]:0+2+2+2", "[B@5]:0+2+2", "[C@0]:0+3+3", "[C@5]:0+3");
            proc2.checkAndClearProcessResult(new String[0]);
            proc3.checkAndClearProcessResult(new String[0]);
            this.setRecordContext(0L, topic1);
            this.driver.process(topic2, "A", "a");
            this.driver.flushState();
            this.setRecordContext(1L, topic1);
            this.driver.process(topic2, "B", "b");
            this.driver.flushState();
            this.setRecordContext(2L, topic1);
            this.driver.process(topic2, "C", "c");
            this.driver.flushState();
            this.setRecordContext(3L, topic1);
            this.driver.process(topic2, "D", "d");
            this.driver.flushState();
            this.setRecordContext(4L, topic1);
            this.driver.process(topic2, "A", "a");
            this.driver.flushState();
            proc1.checkAndClearProcessResult(new String[0]);
            proc2.checkAndClearProcessResult("[A@0]:0+a", "[B@0]:0+b", "[C@0]:0+c", "[D@0]:0+d", "[A@0]:0+a+a");
            proc3.checkAndClearProcessResult("[A@0]:0+1+1+1%0+a", "[B@0]:0+2+2+2%0+b", "[C@0]:0+3+3%0+c", "[D@0]:0+4+4%0+d", "[A@0]:0+1+1+1%0+a+a");
            this.setRecordContext(5L, topic1);
            this.driver.process(topic2, "A", "a");
            this.driver.flushState();
            this.setRecordContext(6L, topic1);
            this.driver.process(topic2, "B", "b");
            this.driver.flushState();
            this.setRecordContext(7L, topic1);
            this.driver.process(topic2, "D", "d");
            this.driver.flushState();
            this.setRecordContext(8L, topic1);
            this.driver.process(topic2, "B", "b");
            this.driver.flushState();
            this.setRecordContext(9L, topic1);
            this.driver.process(topic2, "C", "c");
            this.driver.flushState();
            proc1.checkAndClearProcessResult(new String[0]);
            proc2.checkAndClearProcessResult("[A@0]:0+a+a+a", "[A@5]:0+a", "[B@0]:0+b+b", "[B@5]:0+b", "[D@0]:0+d+d", "[D@5]:0+d", "[B@0]:0+b+b+b", "[B@5]:0+b+b", "[C@0]:0+c+c", "[C@5]:0+c");
            proc3.checkAndClearProcessResult("[A@0]:0+1+1+1%0+a+a+a", "[A@5]:0+1%0+a", "[B@0]:0+2+2+2%0+b+b", "[B@5]:0+2+2%0+b", "[D@0]:0+4+4%0+d+d", "[D@5]:0+4%0+d", "[B@0]:0+2+2+2%0+b+b+b", "[B@5]:0+2+2%0+b+b", "[C@0]:0+3+3%0+c+c", "[C@5]:0+3%0+c");
        }
        finally {
            Utils.delete((File)baseDir);
        }
    }
}

