/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamKTableJoinTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver = null;
    private File stateDir = null;

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testJoin() throws Exception {
        int i;
        KStreamBuilder builder = new KStreamBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(this.intSerde, this.stringSerde, new String[]{"topic1"});
        KTable table = builder.table(this.intSerde, this.stringSerde, "topic2", "anyStoreName");
        stream.join(table, MockValueJoiner.TOSTRING_JOINER).process(processor, new String[0]);
        Collection copartitionGroups = builder.copartitionGroups();
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.setTime(0L);
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        processor.checkAndClearProcessResult(new String[0]);
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        processor.checkAndClearProcessResult(new String[0]);
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        processor.checkAndClearProcessResult(new String[0]);
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        processor.checkAndClearProcessResult("0:X0+YY0", "1:X1+YY1", "2:X2+YY2", "3:X3+YY3");
        for (int i2 = 0; i2 < 2; ++i2) {
            this.driver.process("topic2", expectedKeys[i2], null);
        }
        processor.checkAndClearProcessResult(new String[0]);
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        processor.checkAndClearProcessResult("2:XX2+YY2", "3:XX3+YY3");
    }
}

