/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFilterTest {
    private String topicName = "topic";
    private KStreamTestDriver driver = null;
    private Predicate<Integer, String> isMultipleOfThree = new Predicate<Integer, String>(){

        public boolean test(Integer key, String value) {
            return key % 3 == 0;
        }
    };

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testFilter() {
        KStreamBuilder builder = new KStreamBuilder();
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6, 7};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(Serdes.Integer(), Serdes.String(), new String[]{this.topicName});
        stream.filter(this.isMultipleOfThree).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)2L, (long)processor.processed.size());
    }

    @Test
    public void testFilterNot() {
        KStreamBuilder builder = new KStreamBuilder();
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6, 7};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(Serdes.Integer(), Serdes.String(), new String[]{this.topicName});
        stream.filterNot(this.isMultipleOfThree).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)5L, (long)processor.processed.size());
    }

    @Test
    public void testTypeVariance() throws Exception {
        Predicate<Number, Object> numberKeyPredicate = new Predicate<Number, Object>(){

            public boolean test(Number key, Object value) {
                return false;
            }
        };
        new KStreamBuilder().stream(new String[]{"empty"}).filter((Predicate)numberKeyPredicate).filterNot((Predicate)numberKeyPredicate).to("nirvana");
    }
}

