/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.streams.kstream.Window;
import org.junit.Assert;
import org.junit.Test;

public class WindowTest {
    private final TestWindow window = new TestWindow(5L, 10L);

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfStartIsNegative() {
        new TestWindow(-1L, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfEndIsSmallerThanStart() {
        new TestWindow(1L, 0L);
    }

    @Test
    public void shouldBeEqualIfStartAndEndSame() {
        TestWindow window2 = new TestWindow(this.window.startMs, this.window.endMs);
        Assert.assertEquals((Object)((Object)this.window), (Object)((Object)this.window));
        Assert.assertEquals((Object)((Object)this.window), (Object)((Object)window2));
        Assert.assertEquals((Object)((Object)window2), (Object)((Object)this.window));
    }

    @Test
    public void shouldNotBeEqualIfStartOrEndIsDifferent() {
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(0L, this.window.endMs)));
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(7L, this.window.endMs)));
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(this.window.startMs, 7L)));
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(this.window.startMs, 15L)));
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(7L, 8L)));
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(0L, 15L)));
    }

    @Test
    public void shouldNotBeEqualIfDifferentWindowType() {
        Assert.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow2(this.window.startMs, this.window.endMs)));
    }

    static class TestWindow2
    extends Window {
        TestWindow2(long startMs, long endMs) {
            super(startMs, endMs);
        }

        public boolean overlap(Window other) {
            return false;
        }
    }

    static class TestWindow
    extends Window {
        TestWindow(long startMs, long endMs) {
            super(startMs, endMs);
        }

        public boolean overlap(Window other) {
            return false;
        }
    }
}

