/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.junit.Assert;

public class MockProcessorSupplier<K, V>
implements ProcessorSupplier<K, V> {
    public final ArrayList<String> processed = new ArrayList();
    public final ArrayList<Long> punctuated = new ArrayList();
    private final long scheduleInterval;

    public MockProcessorSupplier() {
        this(-1L);
    }

    public MockProcessorSupplier(long scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public Processor<K, V> get() {
        return new MockProcessor();
    }

    public void checkAndClearProcessResult(String ... expected) {
        Assert.assertEquals((String)("the number of outputs:" + this.processed), (long)expected.length, (long)this.processed.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("output[" + i + "]:"), (Object)expected[i], (Object)this.processed.get(i));
        }
        this.processed.clear();
    }

    public void checkEmptyAndClearProcessResult() {
        Assert.assertEquals((String)"the number of outputs:", (long)0L, (long)this.processed.size());
        this.processed.clear();
    }

    public void checkAndClearPunctuateResult(long ... expected) {
        Assert.assertEquals((String)"the number of outputs:", (long)expected.length, (long)this.punctuated.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("output[" + i + "]:"), (long)expected[i], (long)this.punctuated.get(i));
        }
        this.processed.clear();
    }

    public class MockProcessor
    extends AbstractProcessor<K, V> {
        public void init(ProcessorContext context) {
            super.init(context);
            if (MockProcessorSupplier.this.scheduleInterval > 0L) {
                context.schedule(MockProcessorSupplier.this.scheduleInterval);
            }
        }

        public void process(K key, V value) {
            MockProcessorSupplier.this.processed.add((key == null ? "null" : key) + ":" + (value == null ? "null" : value));
        }

        public void punctuate(long streamTime) {
            Assert.assertEquals((long)streamTime, (long)this.context().timestamp());
            Assert.assertEquals((long)-1L, (long)this.context().partition());
            Assert.assertEquals((long)-1L, (long)this.context().offset());
            MockProcessorSupplier.this.punctuated.add(streamTime);
        }
    }
}

