/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.KStreamTestDriver;

public class MockProcessorContext
implements InternalProcessorContext,
RecordCollector.Supplier {
    private final KStreamTestDriver driver;
    private final Serde<?> keySerde;
    private final Serde<?> valSerde;
    private final RecordCollector.Supplier recordCollectorSupplier;
    private final File stateDir;
    private final ThreadCache cache;
    private Map<String, StateStore> storeMap = new LinkedHashMap<String, StateStore>();
    private Map<String, StateRestoreCallback> restoreFuncs = new HashMap<String, StateRestoreCallback>();
    long timestamp = -1L;
    private RecordContext recordContext;

    public MockProcessorContext(StateSerdes<?, ?> serdes, RecordCollector collector) {
        this(null, null, serdes.keySerde(), serdes.valueSerde(), collector, null);
    }

    public MockProcessorContext(KStreamTestDriver driver, File stateDir, Serde<?> keySerde, Serde<?> valSerde, final RecordCollector collector, ThreadCache cache) {
        this(driver, stateDir, keySerde, valSerde, new RecordCollector.Supplier(){

            public RecordCollector recordCollector() {
                return collector;
            }
        }, cache);
    }

    public MockProcessorContext(KStreamTestDriver driver, File stateDir, Serde<?> keySerde, Serde<?> valSerde, RecordCollector.Supplier collectorSupplier, ThreadCache cache) {
        this.driver = driver;
        this.stateDir = stateDir;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.recordCollectorSupplier = collectorSupplier;
        this.cache = cache;
    }

    public RecordCollector recordCollector() {
        RecordCollector recordCollector = this.recordCollectorSupplier.recordCollector();
        if (recordCollector == null) {
            throw new UnsupportedOperationException("No RecordCollector specified");
        }
        return recordCollector;
    }

    public void setTime(long timestamp) {
        this.timestamp = timestamp;
    }

    public TaskId taskId() {
        return new TaskId(0, 0);
    }

    public String applicationId() {
        return "mockApplication";
    }

    public Serde<?> keySerde() {
        return this.keySerde;
    }

    public Serde<?> valueSerde() {
        return this.valSerde;
    }

    public ThreadCache getCache() {
        return this.cache;
    }

    public File stateDir() {
        if (this.stateDir == null) {
            throw new UnsupportedOperationException("State directory not specified");
        }
        return this.stateDir;
    }

    public StreamsMetrics metrics() {
        return new StreamsMetrics(){

            public Sensor addLatencySensor(String scopeName, String entityName, String operationName, String ... tags) {
                return null;
            }

            public void recordLatency(Sensor sensor, long startNs, long endNs) {
            }
        };
    }

    public void register(StateStore store, boolean loggingEnabled, StateRestoreCallback func) {
        this.storeMap.put(store.name(), store);
        this.restoreFuncs.put(store.name(), func);
    }

    public StateStore getStateStore(String name) {
        return this.storeMap.get(name);
    }

    public void schedule(long interval) {
        throw new UnsupportedOperationException("schedule() not supported.");
    }

    public <K, V> void forward(K key, V value) {
        this.driver.forward(key, value);
    }

    public <K, V> void forward(K key, V value, int childIndex) {
        this.driver.forward(key, value, childIndex);
    }

    public <K, V> void forward(K key, V value, String childName) {
        this.driver.forward(key, value, childName);
    }

    public void commit() {
        throw new UnsupportedOperationException("commit() not supported.");
    }

    public String topic() {
        if (this.recordContext == null) {
            return null;
        }
        return this.recordContext.topic();
    }

    public int partition() {
        if (this.recordContext == null) {
            return -1;
        }
        return this.recordContext.partition();
    }

    public long offset() {
        if (this.recordContext == null) {
            return -1L;
        }
        return this.recordContext.offset();
    }

    public long timestamp() {
        if (this.recordContext == null) {
            return this.timestamp;
        }
        return this.recordContext.timestamp();
    }

    public Map<String, Object> appConfigs() {
        return Collections.emptyMap();
    }

    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return Collections.emptyMap();
    }

    public RecordContext recordContext() {
        return this.recordContext;
    }

    public Map<String, StateStore> allStateStores() {
        return Collections.unmodifiableMap(this.storeMap);
    }

    public void restore(String storeName, List<KeyValue<byte[], byte[]>> changeLog) {
        StateRestoreCallback restoreCallback = this.restoreFuncs.get(storeName);
        for (KeyValue<byte[], byte[]> entry : changeLog) {
            restoreCallback.restore((byte[])entry.key, (byte[])entry.value);
        }
    }

    public void setRecordContext(RecordContext recordContext) {
        this.recordContext = recordContext;
    }

    public void setCurrentNode(ProcessorNode currentNode) {
    }
}

