/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;

public class MockKeyValueMapper {
    public static <K, V> KeyValueMapper<K, V, KeyValue<K, V>> NoOpKeyValueMapper() {
        return new NoOpKeyValueMapper();
    }

    public static <K, V> KeyValueMapper<K, V, KeyValue<V, V>> SelectValueKeyValueMapper() {
        return new SelectValueKeyValueMapper();
    }

    public static <K, V> KeyValueMapper<K, V, V> SelectValueMapper() {
        return new SelectValueMapper();
    }

    private static class SelectValueMapper<K, V>
    implements KeyValueMapper<K, V, V> {
        private SelectValueMapper() {
        }

        public V apply(K key, V value) {
            return value;
        }
    }

    private static class SelectValueKeyValueMapper<K, V>
    implements KeyValueMapper<K, V, KeyValue<V, V>> {
        private SelectValueKeyValueMapper() {
        }

        public KeyValue<V, V> apply(K key, V value) {
            return KeyValue.pair(value, value);
        }
    }

    private static class NoOpKeyValueMapper<K, V>
    implements KeyValueMapper<K, V, KeyValue<K, V>> {
        private NoOpKeyValueMapper() {
        }

        public KeyValue<K, V> apply(K key, V value) {
            return KeyValue.pair(key, value);
        }
    }
}

