/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.Assert;
import org.junit.Test;

public class StoreChangeLoggerTest {
    private final String topic = "topic";
    private final Map<Integer, String> logged = new HashMap<Integer, String>();
    private final Map<Integer, String> written = new HashMap<Integer, String>();
    private final MockProcessorContext context = new MockProcessorContext(StateSerdes.withBuiltinTypes((String)"topic", Integer.class, String.class), new RecordCollector(null, "StoreChangeLoggerTest"){

        public <K1, V1> void send(ProducerRecord<K1, V1> record, Serializer<K1> keySerializer, Serializer<V1> valueSerializer) {
            StoreChangeLoggerTest.this.logged.put((Integer)record.key(), (String)record.value());
        }

        public <K1, V1> void send(ProducerRecord<K1, V1> record, Serializer<K1> keySerializer, Serializer<V1> valueSerializer, StreamPartitioner<K1, V1> partitioner) {
            this.send(record, keySerializer, valueSerializer);
        }
    });
    private final StoreChangeLogger<Integer, String> changeLogger = new StoreChangeLogger("topic", (ProcessorContext)this.context, StateSerdes.withBuiltinTypes((String)"topic", Integer.class, String.class), 3, 3);
    private final StoreChangeLogger.ValueGetter<Integer, String> getter = new StoreChangeLogger.ValueGetter<Integer, String>(){

        public String get(Integer key) {
            return (String)StoreChangeLoggerTest.this.written.get(key);
        }
    };

    @Test
    public void testAddRemove() {
        this.context.setTime(1L);
        this.written.put(0, "zero");
        this.changeLogger.add((Object)0);
        this.written.put(1, "one");
        this.changeLogger.add((Object)1);
        this.written.put(2, "two");
        this.changeLogger.add((Object)2);
        Assert.assertEquals((long)3L, (long)this.changeLogger.numDirty());
        Assert.assertEquals((long)0L, (long)this.changeLogger.numRemoved());
        this.changeLogger.delete((Object)0);
        this.changeLogger.delete((Object)1);
        this.written.put(3, "three");
        this.changeLogger.add((Object)3);
        Assert.assertEquals((long)2L, (long)this.changeLogger.numDirty());
        Assert.assertEquals((long)2L, (long)this.changeLogger.numRemoved());
        this.written.put(0, "zero-again");
        this.changeLogger.add((Object)0);
        Assert.assertEquals((long)3L, (long)this.changeLogger.numDirty());
        Assert.assertEquals((long)1L, (long)this.changeLogger.numRemoved());
        this.written.put(4, "four");
        this.changeLogger.add((Object)4);
        this.changeLogger.maybeLogChange(this.getter);
        Assert.assertEquals((long)0L, (long)this.changeLogger.numDirty());
        Assert.assertEquals((long)0L, (long)this.changeLogger.numRemoved());
        Assert.assertEquals((long)5L, (long)this.logged.size());
        Assert.assertEquals((Object)"zero-again", (Object)this.logged.get(0));
        Assert.assertEquals(null, (Object)this.logged.get(1));
        Assert.assertEquals((Object)"two", (Object)this.logged.get(2));
        Assert.assertEquals((Object)"three", (Object)this.logged.get(3));
        Assert.assertEquals((Object)"four", (Object)this.logged.get(4));
    }
}

