/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStoreSupplier;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;

public class StateStoreTestUtils {
    public static <K, V> KeyValueStore<K, V> newKeyValueStore(String name, Class<K> keyType, Class<V> valueType) {
        InMemoryKeyValueStoreSupplier supplier = new InMemoryKeyValueStoreSupplier(name, null, null, (Time)new MockTime(), false, Collections.emptyMap());
        StateStore stateStore = supplier.get();
        stateStore.init((ProcessorContext)new MockProcessorContext(StateSerdes.withBuiltinTypes((String)name, keyType, valueType), new NoOpRecordCollector()), stateStore);
        return (KeyValueStore)stateStore;
    }

    static class NoOpReadOnlyStore<K, V>
    implements ReadOnlyKeyValueStore<K, V>,
    StateStore {
        NoOpReadOnlyStore() {
        }

        public V get(K key) {
            return null;
        }

        public KeyValueIterator<K, V> range(K from, K to) {
            return null;
        }

        public KeyValueIterator<K, V> all() {
            return null;
        }

        public long approximateNumEntries() {
            return 0L;
        }

        public String name() {
            return "";
        }

        public void init(ProcessorContext context, StateStore root) {
        }

        public void flush() {
        }

        public void close() {
        }

        public boolean persistent() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }
    }
}

