/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.KeyValueStoreTestDriver;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.Assert;
import org.junit.Test;
import org.rocksdb.Options;

public class RocksDBKeyValueStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context, Class<K> keyClass, Class<V> valueClass, boolean useContextSerdes) {
        return this.createStore(context, keyClass, valueClass, useContextSerdes, false);
    }

    private <K, V> KeyValueStore<K, V> createStore(ProcessorContext context, Class<K> keyClass, Class<V> valueClass, boolean useContextSerdes, boolean enableCaching) {
        Stores.PersistentKeyValueFactory factory = null;
        factory = useContextSerdes ? Stores.create((String)"my-store").withKeys(context.keySerde()).withValues(context.valueSerde()).persistent() : Stores.create((String)"my-store").withKeys(keyClass).withValues(valueClass).persistent();
        if (enableCaching) {
            factory.enableCaching();
        }
        KeyValueStore store = (KeyValueStore)factory.build().get();
        store.init(context, (StateStore)store);
        return store;
    }

    @Test
    public void shouldUseCustomRocksDbConfigSetter() throws Exception {
        KeyValueStoreTestDriver<Integer, String> driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        driver.setConfig("rocksdb.config.setter", TheRocksDbConfigSetter.class);
        this.createKeyValueStore(driver.context(), Integer.class, String.class, false);
        Assert.assertTrue((boolean)TheRocksDbConfigSetter.called);
    }

    @Test
    public void shouldPerformRangeQueriesWithCachingDisabled() throws Exception {
        KeyValueStoreTestDriver<Integer, String> driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        KeyValueStore<Integer, String> store = this.createStore(driver.context(), Integer.class, String.class, false, false);
        store.put((Object)1, (Object)"hi");
        store.put((Object)2, (Object)"goodbye");
        KeyValueIterator range = store.range((Object)1, (Object)2);
        Assert.assertEquals((Object)"hi", (Object)((KeyValue)range.next()).value);
        Assert.assertEquals((Object)"goodbye", (Object)((KeyValue)range.next()).value);
        Assert.assertFalse((boolean)range.hasNext());
    }

    @Test
    public void shouldPerformAllQueriesWithCachingDisabled() throws Exception {
        KeyValueStoreTestDriver<Integer, String> driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        KeyValueStore<Integer, String> store = this.createStore(driver.context(), Integer.class, String.class, false, false);
        store.put((Object)1, (Object)"hi");
        store.put((Object)2, (Object)"goodbye");
        KeyValueIterator range = store.all();
        Assert.assertEquals((Object)"hi", (Object)((KeyValue)range.next()).value);
        Assert.assertEquals((Object)"goodbye", (Object)((KeyValue)range.next()).value);
        Assert.assertFalse((boolean)range.hasNext());
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreClosedAndThrowInvalidStateStoreOnHasNextAndNext() throws Exception {
        KeyValueStoreTestDriver<Integer, String> driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        MockProcessorContext context = (MockProcessorContext)driver.context();
        context.setTime(1L);
        KeyValueStore<Integer, String> store = this.createStore((ProcessorContext)context, Integer.class, String.class, false, false);
        store.put((Object)1, (Object)"hi");
        store.put((Object)2, (Object)"goodbye");
        KeyValueIterator iteratorOne = store.range((Object)1, (Object)5);
        KeyValueIterator iteratorTwo = store.range((Object)1, (Object)4);
        Assert.assertTrue((boolean)iteratorOne.hasNext());
        Assert.assertTrue((boolean)iteratorTwo.hasNext());
        store.close();
        try {
            iteratorOne.hasNext();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException e) {
            // empty catch block
        }
        try {
            iteratorOne.next();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException e) {
            // empty catch block
        }
        try {
            iteratorTwo.hasNext();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException e) {
            // empty catch block
        }
        try {
            iteratorTwo.next();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException e) {
            // empty catch block
        }
    }

    public static class TheRocksDbConfigSetter
    implements RocksDBConfigSetter {
        static boolean called = false;

        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            called = true;
        }
    }
}

