/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class ReadOnlyWindowStoreStub<K, V>
implements ReadOnlyWindowStore<K, V>,
StateStore {
    private final Map<Long, Map<K, V>> data = new HashMap<Long, Map<K, V>>();
    private boolean open = true;

    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("Store is not open");
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (long now = timeFrom; now <= timeTo; ++now) {
            Map<K, V> kvMap = this.data.get(now);
            if (kvMap == null || !kvMap.containsKey(key)) continue;
            results.add(new KeyValue((Object)now, kvMap.get(key)));
        }
        return new TheWindowStoreIterator(results.iterator());
    }

    public void put(K key, V value, long timestamp) {
        if (!this.data.containsKey(timestamp)) {
            this.data.put(timestamp, new HashMap());
        }
        this.data.get(timestamp).put(key, value);
    }

    public String name() {
        return null;
    }

    public void init(ProcessorContext context, StateStore root) {
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    private class TheWindowStoreIterator<E>
    implements WindowStoreIterator<E> {
        private final Iterator<KeyValue<Long, E>> underlying;

        TheWindowStoreIterator(Iterator<KeyValue<Long, E>> underlying) {
            this.underlying = underlying;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        public KeyValue<Long, E> next() {
            return this.underlying.next();
        }

        public void remove() {
        }
    }
}

