/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.NamedCache;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NamedCacheTest {
    private NamedCache cache;

    @Before
    public void setUp() throws Exception {
        this.cache = new NamedCache("name");
    }

    @Test
    public void shouldKeepTrackOfMostRecentlyAndLeastRecentlyUsed() throws IOException {
        List<KeyValue> toInsert = Arrays.asList(new KeyValue((Object)"K1", (Object)"V1"), new KeyValue((Object)"K2", (Object)"V2"), new KeyValue((Object)"K3", (Object)"V3"), new KeyValue((Object)"K4", (Object)"V4"), new KeyValue((Object)"K5", (Object)"V5"));
        for (int i = 0; i < toInsert.size(); ++i) {
            byte[] key = ((String)toInsert.get((int)i).key).getBytes();
            byte[] value = ((String)toInsert.get((int)i).value).getBytes();
            this.cache.put(Bytes.wrap((byte[])key), new LRUCacheEntry(value, true, 1L, 1L, 1, ""));
            LRUCacheEntry head = this.cache.first();
            LRUCacheEntry tail = this.cache.last();
            Assert.assertEquals((Object)new String(head.value), (Object)toInsert.get((int)i).value);
            Assert.assertEquals((Object)new String(tail.value), (Object)toInsert.get((int)0).value);
            Assert.assertEquals((long)this.cache.flushes(), (long)0L);
            Assert.assertEquals((long)this.cache.hits(), (long)0L);
            Assert.assertEquals((long)this.cache.misses(), (long)0L);
            Assert.assertEquals((long)this.cache.overwrites(), (long)0L);
        }
    }

    @Test
    public void shouldKeepTrackOfSize() throws Exception {
        LRUCacheEntry value = new LRUCacheEntry(new byte[]{0});
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), value);
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), value);
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), value);
        long size = this.cache.sizeInBytes();
        Assert.assertEquals((long)((value.size() + 25L) * 3L), (long)size);
    }

    @Test
    public void shouldPutGet() throws Exception {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{11}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{12}));
        Assert.assertArrayEquals((byte[])new byte[]{10}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{0})).value);
        Assert.assertArrayEquals((byte[])new byte[]{11}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{1})).value);
        Assert.assertArrayEquals((byte[])new byte[]{12}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{2})).value);
        Assert.assertEquals((long)this.cache.hits(), (long)3L);
    }

    @Test
    public void shouldPutIfAbsent() throws Exception {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        this.cache.putIfAbsent(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{20}));
        this.cache.putIfAbsent(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{30}));
        Assert.assertArrayEquals((byte[])new byte[]{10}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{0})).value);
        Assert.assertArrayEquals((byte[])new byte[]{30}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{1})).value);
    }

    @Test
    public void shouldDeleteAndUpdateSize() throws Exception {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        LRUCacheEntry deleted = this.cache.delete(Bytes.wrap((byte[])new byte[]{0}));
        Assert.assertArrayEquals((byte[])new byte[]{10}, (byte[])deleted.value);
        Assert.assertEquals((long)0L, (long)this.cache.sizeInBytes());
    }

    @Test
    public void shouldPutAll() throws Exception {
        this.cache.putAll(Arrays.asList(KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{0})), KeyValue.pair((Object)new byte[]{1}, (Object)new LRUCacheEntry(new byte[]{1})), KeyValue.pair((Object)new byte[]{2}, (Object)new LRUCacheEntry(new byte[]{2}))));
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{0})).value);
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{1})).value);
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{2})).value);
    }

    @Test
    public void shouldOverwriteAll() throws Exception {
        this.cache.putAll(Arrays.asList(KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{0})), KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{1})), KeyValue.pair((Object)new byte[]{0}, (Object)new LRUCacheEntry(new byte[]{2}))));
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])this.cache.get((Bytes)Bytes.wrap((byte[])new byte[]{0})).value);
        Assert.assertEquals((long)this.cache.overwrites(), (long)2L);
    }

    @Test
    public void shouldEvictEldestEntry() throws Exception {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{30}));
        this.cache.evict();
        Assert.assertNull((Object)this.cache.get(Bytes.wrap((byte[])new byte[]{0})));
        Assert.assertEquals((long)2L, (long)this.cache.size());
    }

    @Test
    public void shouldFlushDirtEntriesOnEviction() throws Exception {
        final ArrayList flushed = new ArrayList();
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}, true, 0L, 0L, 0, ""));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{30}, true, 0L, 0L, 0, ""));
        this.cache.setListener(new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                flushed.addAll(dirty);
            }
        });
        this.cache.evict();
        Assert.assertEquals((long)2L, (long)flushed.size());
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{0}), (Object)((ThreadCache.DirtyEntry)flushed.get(0)).key());
        Assert.assertArrayEquals((byte[])new byte[]{10}, (byte[])((ThreadCache.DirtyEntry)flushed.get(0)).newValue());
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{2}), (Object)((ThreadCache.DirtyEntry)flushed.get(1)).key());
        Assert.assertArrayEquals((byte[])new byte[]{30}, (byte[])((ThreadCache.DirtyEntry)flushed.get(1)).newValue());
        Assert.assertEquals((long)this.cache.flushes(), (long)1L);
    }

    @Test
    public void shouldGetRangeIteratorOverKeys() throws Exception {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}, true, 0L, 0L, 0, ""));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{30}, true, 0L, 0L, 0, ""));
        Iterator iterator = this.cache.keyRange(Bytes.wrap((byte[])new byte[]{1}), Bytes.wrap((byte[])new byte[]{2}));
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{1}), iterator.next());
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{2}), iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldGetIteratorOverAllKeys() throws Exception {
        this.cache.put(Bytes.wrap((byte[])new byte[]{0}), new LRUCacheEntry(new byte[]{10}, true, 0L, 0L, 0, ""));
        this.cache.put(Bytes.wrap((byte[])new byte[]{1}), new LRUCacheEntry(new byte[]{20}));
        this.cache.put(Bytes.wrap((byte[])new byte[]{2}), new LRUCacheEntry(new byte[]{30}, true, 0L, 0L, 0, ""));
        Iterator iterator = this.cache.allKeys();
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{0}), iterator.next());
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{1}), iterator.next());
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{2}), iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldNotThrowNullPointerWhenCacheIsEmptyAndEvictionCalled() throws Exception {
        this.cache.evict();
    }
}

